/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.plc.client;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.client.AddressSpace;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.Optional;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.types.opcua.client.BaseObjectTypeImpl;
import com.prosysopc.ua.types.plc.CtrlTaskType;
import org.opcfoundation.ua.builtintypes.LocalizedText;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.QualifiedName;
import org.opcfoundation.ua.builtintypes.UnsignedInteger;

public abstract class CtrlTaskTypeImplBase
extends BaseObjectTypeImpl
implements CtrlTaskType {
    protected CtrlTaskTypeImplBase(AddressSpace addressSpace, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        super(addressSpace, nodeId, qualifiedName, localizedText);
    }

    @Override
    @Mandatory
    public UaProperty getPriorityNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://PLCopen.org/OpcUa/IEC61131-3/", "Priority");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public UnsignedInteger getPriority() {
        Object object = this.getPriorityNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (UnsignedInteger)object;
    }

    @Override
    @Mandatory
    public void setPriority(UnsignedInteger unsignedInteger) throws StatusException {
        UaProperty uaProperty = this.getPriorityNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting Priority failed, the Optional node does not exist");
        }
        uaProperty.setValue(unsignedInteger);
    }

    @Override
    @Optional
    public UaProperty getIntervalNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://PLCopen.org/OpcUa/IEC61131-3/", "Interval");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public String getInterval() {
        Object object = this.getIntervalNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (String)object;
    }

    @Override
    @Optional
    public void setInterval(String string) throws StatusException {
        UaProperty uaProperty = this.getIntervalNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting Interval failed, the Optional node does not exist");
        }
        uaProperty.setValue(string);
    }

    @Override
    @Optional
    public UaProperty getSingleNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://PLCopen.org/OpcUa/IEC61131-3/", "Single");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public String getSingle() {
        Object object = this.getSingleNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (String)object;
    }

    @Override
    @Optional
    public void setSingle(String string) throws StatusException {
        UaProperty uaProperty = this.getSingleNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting Single failed, the Optional node does not exist");
        }
        uaProperty.setValue(string);
    }
}

