/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.plc.client;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.client.AddressSpace;
import com.prosysopc.ua.nodes.Optional;
import com.prosysopc.ua.types.opcua.BaseDataVariableType;
import com.prosysopc.ua.types.plc.CtrlProgramType;
import com.prosysopc.ua.types.plc.client.CtrlProgramOrganizationUnitTypeImpl;
import org.opcfoundation.ua.builtintypes.LocalizedText;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.QualifiedName;
import org.opcfoundation.ua.builtintypes.Structure;

public abstract class CtrlProgramTypeImplBase
extends CtrlProgramOrganizationUnitTypeImpl
implements CtrlProgramType {
    protected CtrlProgramTypeImplBase(AddressSpace addressSpace, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        super(addressSpace, nodeId, qualifiedName, localizedText);
    }

    @Override
    @Optional
    public BaseDataVariableType getProgramNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://PLCopen.org/OpcUa/IEC61131-3/", "Program");
        return (BaseDataVariableType)this.getComponent(qualifiedName);
    }

    @Override
    @Optional
    public Structure getProgram() {
        Object object = this.getProgramNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (Structure)object;
    }

    @Override
    @Optional
    public void setProgram(Structure structure) throws StatusException {
        BaseDataVariableType baseDataVariableType = this.getProgramNode();
        if (baseDataVariableType == null) {
            throw new RuntimeException("Setting Program failed, the Optional node does not exist");
        }
        baseDataVariableType.setValue(structure);
    }
}

