/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.Optional;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.server.NodeManagerUaNode;
import com.prosysopc.ua.types.opcua.TwoStateVariableType;
import com.prosysopc.ua.types.opcua.server.StateVariableTypeNode;
import org.opcfoundation.ua.builtintypes.DateTime;
import org.opcfoundation.ua.builtintypes.LocalizedText;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.QualifiedName;

public abstract class TwoStateVariableTypeNodeBase
extends StateVariableTypeNode
implements TwoStateVariableType {
    protected TwoStateVariableTypeNodeBase(NodeManagerUaNode nodeManagerUaNode, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        super(nodeManagerUaNode, nodeId, qualifiedName, localizedText);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
    }

    @Override
    @Mandatory
    public UaProperty getIdNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Id");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public Boolean isId() {
        Object object = this.getIdNode();
        if (object == null) {
            throw new RuntimeException("Mandatory node Id does not exist");
        }
        object = object.getValue().getValue().getValue();
        return (Boolean)object;
    }

    @Override
    @Mandatory
    public void setId(Boolean bl) {
        UaProperty uaProperty = this.getIdNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting Id failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(bl);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting Id failed unexpectedly", statusException);
        }
    }

    @Override
    @Optional
    public UaProperty getTransitionTimeNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "TransitionTime");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public DateTime getTransitionTime() {
        Object object = this.getTransitionTimeNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (DateTime)object;
    }

    @Override
    @Optional
    public void setTransitionTime(DateTime dateTime) {
        UaProperty uaProperty = this.getTransitionTimeNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting TransitionTime failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(dateTime);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting TransitionTime failed unexpectedly", statusException);
        }
    }

    @Override
    @Optional
    public UaProperty getEffectiveTransitionTimeNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "EffectiveTransitionTime");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public DateTime getEffectiveTransitionTime() {
        Object object = this.getEffectiveTransitionTimeNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (DateTime)object;
    }

    @Override
    @Optional
    public void setEffectiveTransitionTime(DateTime dateTime) {
        UaProperty uaProperty = this.getEffectiveTransitionTimeNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting EffectiveTransitionTime failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(dateTime);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting EffectiveTransitionTime failed unexpectedly", statusException);
        }
    }

    @Override
    @Optional
    public UaProperty getTrueStateNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "TrueState");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public LocalizedText getTrueState() {
        Object object = this.getTrueStateNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (LocalizedText)object;
    }

    @Override
    @Optional
    public void setTrueState(LocalizedText localizedText) {
        UaProperty uaProperty = this.getTrueStateNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting TrueState failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(localizedText);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting TrueState failed unexpectedly", statusException);
        }
    }

    @Override
    @Optional
    public UaProperty getFalseStateNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "FalseState");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public LocalizedText getFalseState() {
        Object object = this.getFalseStateNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (LocalizedText)object;
    }

    @Override
    @Optional
    public void setFalseState(LocalizedText localizedText) {
        UaProperty uaProperty = this.getFalseStateNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting FalseState failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(localizedText);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting FalseState failed unexpectedly", statusException);
        }
    }
}

