/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.server.NodeManagerUaNode;
import com.prosysopc.ua.types.opcua.server.TwoStateVariableTypeNodeBase;
import java.util.Locale;
import org.opcfoundation.ua.builtintypes.DataValue;
import org.opcfoundation.ua.builtintypes.DateTime;
import org.opcfoundation.ua.builtintypes.LocalizedText;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.QualifiedName;
import org.opcfoundation.ua.builtintypes.StatusCode;
import org.opcfoundation.ua.builtintypes.Variant;
import org.opcfoundation.ua.core.StatusCodes;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=8995")
public class TwoStateVariableTypeNode
extends TwoStateVariableTypeNodeBase {
    protected TwoStateVariableTypeNode(NodeManagerUaNode nodeManagerUaNode, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        super(nodeManagerUaNode, nodeId, qualifiedName, localizedText);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
        this.setValueRank(-1);
        this.setId(false);
    }

    public void setFalseState(String string, Locale locale) {
        this.setFalseState(new LocalizedText(string, locale));
    }

    public void setId(boolean bl, DateTime dateTime) {
        if (bl != this.isId() || this.getValue() != null && this.getValue().getStatusCode().isBad()) {
            super.setId(bl);
            this.setIdWithTime(bl, dateTime);
        }
    }

    @Override
    public void setId(Boolean bl) {
        super.setId(bl);
        this.setIdWithTime(bl, null);
    }

    public void setTrueState(String string, Locale locale) {
        this.setTrueState(new LocalizedText(string, locale));
    }

    protected void setIdWithTime(Boolean bl, DateTime dateTime) {
        if (dateTime == null) {
            dateTime = DateTime.currentTime();
        }
        try {
            DataValue dataValue = bl == null ? new DataValue(new StatusCode(StatusCodes.Bad_AttributeIdInvalid)) : new DataValue(new Variant((Object)(bl != false ? this.getTrueState() : this.getFalseState())));
            dataValue.setSourceTimestamp(dateTime);
            this.setValue(dataValue);
            if (this.getTransitionTimeNode() != null) {
                this.setTransitionTime(dateTime);
            }
            if (this.getEffectiveTransitionTimeNode() != null) {
                this.setEffectiveTransitionTime(dateTime);
            }
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("setId: " + bl, statusException);
        }
    }
}

