/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.server.NodeManagerUaNode;
import com.prosysopc.ua.types.opcua.TwoStateDiscreteType;
import com.prosysopc.ua.types.opcua.server.DiscreteItemTypeNode;
import org.opcfoundation.ua.builtintypes.LocalizedText;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.QualifiedName;

public abstract class TwoStateDiscreteTypeNodeBase
extends DiscreteItemTypeNode
implements TwoStateDiscreteType {
    protected TwoStateDiscreteTypeNodeBase(NodeManagerUaNode nodeManagerUaNode, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        super(nodeManagerUaNode, nodeId, qualifiedName, localizedText);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
    }

    @Override
    @Mandatory
    public UaProperty getFalseStateNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "FalseState");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public LocalizedText getFalseState() {
        Object object = this.getFalseStateNode();
        if (object == null) {
            throw new RuntimeException("Mandatory node FalseState does not exist");
        }
        object = object.getValue().getValue().getValue();
        return (LocalizedText)object;
    }

    @Override
    @Mandatory
    public void setFalseState(LocalizedText localizedText) {
        UaProperty uaProperty = this.getFalseStateNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting FalseState failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(localizedText);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting FalseState failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public UaProperty getTrueStateNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "TrueState");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public LocalizedText getTrueState() {
        Object object = this.getTrueStateNode();
        if (object == null) {
            throw new RuntimeException("Mandatory node TrueState does not exist");
        }
        object = object.getValue().getValue().getValue();
        return (LocalizedText)object;
    }

    @Override
    @Mandatory
    public void setTrueState(LocalizedText localizedText) {
        UaProperty uaProperty = this.getTrueStateNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting TrueState failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(localizedText);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting TrueState failed unexpectedly", statusException);
        }
    }
}

