/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.server.NodeManagerUaNode;
import com.prosysopc.ua.server.ServiceContext;
import com.prosysopc.ua.types.opcua.TrustListType;
import com.prosysopc.ua.types.opcua.server.FileTypeNode;
import org.opcfoundation.ua.builtintypes.DateTime;
import org.opcfoundation.ua.builtintypes.DiagnosticInfo;
import org.opcfoundation.ua.builtintypes.LocalizedText;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.QualifiedName;
import org.opcfoundation.ua.builtintypes.StatusCode;
import org.opcfoundation.ua.builtintypes.UnsignedInteger;
import org.opcfoundation.ua.builtintypes.Variant;

public abstract class TrustListTypeNodeBase
extends FileTypeNode
implements TrustListType {
    protected TrustListTypeNodeBase(NodeManagerUaNode nodeManagerUaNode, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        super(nodeManagerUaNode, nodeId, qualifiedName, localizedText);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
    }

    @Override
    @Mandatory
    public UaProperty getLastUpdateTimeNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "LastUpdateTime");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public DateTime getLastUpdateTime() {
        Object object = this.getLastUpdateTimeNode();
        if (object == null) {
            throw new RuntimeException("Mandatory node LastUpdateTime does not exist");
        }
        object = object.getValue().getValue().getValue();
        return (DateTime)object;
    }

    @Override
    @Mandatory
    public void setLastUpdateTime(DateTime dateTime) {
        UaProperty uaProperty = this.getLastUpdateTimeNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting LastUpdateTime failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(dateTime);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting LastUpdateTime failed unexpectedly", statusException);
        }
    }

    @Override
    public Variant[] callMethod(ServiceContext object, NodeId nodeId, Variant[] variantArray, StatusCode[] statusCodeArray, DiagnosticInfo[] diagnosticInfoArray) throws StatusException {
        Object object2 = this.getQualifiedName("http://opcfoundation.org/UA/", "OpenWithMasks");
        if ((object2 = this.getComponent((QualifiedName)object2)) != null && object2.getNodeId().equals((Object)nodeId)) {
            object = this.onOpenWithMasks((ServiceContext)object, (UnsignedInteger)variantArray[0].getValue());
            return new Variant[]{new Variant(object)};
        }
        object2 = this.getQualifiedName("http://opcfoundation.org/UA/", "CloseAndUpdate");
        if ((object2 = this.getComponent((QualifiedName)object2)) != null && object2.getNodeId().equals((Object)nodeId)) {
            object = this.onCloseAndUpdate((ServiceContext)object, (UnsignedInteger)variantArray[0].getValue());
            return new Variant[]{new Variant(object)};
        }
        object2 = this.getQualifiedName("http://opcfoundation.org/UA/", "AddCertificate");
        if ((object2 = this.getComponent((QualifiedName)object2)) != null && object2.getNodeId().equals((Object)nodeId)) {
            this.onAddCertificate((ServiceContext)object, (byte[])variantArray[0].getValue(), (Boolean)variantArray[1].getValue());
            return null;
        }
        object2 = this.getQualifiedName("http://opcfoundation.org/UA/", "RemoveCertificate");
        if ((object2 = this.getComponent((QualifiedName)object2)) != null && object2.getNodeId().equals((Object)nodeId)) {
            this.onRemoveCertificate((ServiceContext)object, (String)variantArray[0].getValue(), (Boolean)variantArray[1].getValue());
            return null;
        }
        return super.callMethod((ServiceContext)object, nodeId, variantArray, statusCodeArray, diagnosticInfoArray);
    }

    @Override
    public UnsignedInteger openWithMasks(UnsignedInteger unsignedInteger) throws StatusException {
        return this.onOpenWithMasks(ServiceContext.INTERNAL_OPERATION_CONTEXT, unsignedInteger);
    }

    protected abstract UnsignedInteger onOpenWithMasks(ServiceContext var1, UnsignedInteger var2) throws StatusException;

    @Override
    public Boolean closeAndUpdate(UnsignedInteger unsignedInteger) throws StatusException {
        return this.onCloseAndUpdate(ServiceContext.INTERNAL_OPERATION_CONTEXT, unsignedInteger);
    }

    protected abstract Boolean onCloseAndUpdate(ServiceContext var1, UnsignedInteger var2) throws StatusException;

    @Override
    public void addCertificate(byte[] byArray, Boolean bl) throws StatusException {
        this.onAddCertificate(ServiceContext.INTERNAL_OPERATION_CONTEXT, byArray, bl);
    }

    protected abstract void onAddCertificate(ServiceContext var1, byte[] var2, Boolean var3) throws StatusException;

    @Override
    public void removeCertificate(String string, Boolean bl) throws StatusException {
        this.onRemoveCertificate(ServiceContext.INTERNAL_OPERATION_CONTEXT, string, bl);
    }

    protected abstract void onRemoveCertificate(ServiceContext var1, String var2, Boolean var3) throws StatusException;
}

