/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.server.NodeManagerUaNode;
import com.prosysopc.ua.types.opcua.TransparentRedundancyType;
import com.prosysopc.ua.types.opcua.server.ServerRedundancyTypeNode;
import org.opcfoundation.ua.builtintypes.LocalizedText;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.QualifiedName;
import org.opcfoundation.ua.core.RedundantServerDataType;

public abstract class TransparentRedundancyTypeNodeBase
extends ServerRedundancyTypeNode
implements TransparentRedundancyType {
    protected TransparentRedundancyTypeNodeBase(NodeManagerUaNode nodeManagerUaNode, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        super(nodeManagerUaNode, nodeId, qualifiedName, localizedText);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
    }

    @Override
    @Mandatory
    public UaProperty getCurrentServerIdNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "CurrentServerId");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public String getCurrentServerId() {
        Object object = this.getCurrentServerIdNode();
        if (object == null) {
            throw new RuntimeException("Mandatory node CurrentServerId does not exist");
        }
        object = object.getValue().getValue().getValue();
        return (String)object;
    }

    @Override
    @Mandatory
    public void setCurrentServerId(String string) {
        UaProperty uaProperty = this.getCurrentServerIdNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting CurrentServerId failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(string);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting CurrentServerId failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public UaProperty getRedundantServerArrayNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "RedundantServerArray");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public RedundantServerDataType[] getRedundantServerArray() {
        Object object = this.getRedundantServerArrayNode();
        if (object == null) {
            throw new RuntimeException("Mandatory node RedundantServerArray does not exist");
        }
        object = object.getValue().getValue().getValue();
        return (RedundantServerDataType[])object;
    }

    @Override
    @Mandatory
    public void setRedundantServerArray(RedundantServerDataType[] redundantServerDataTypeArray) {
        UaProperty uaProperty = this.getRedundantServerArrayNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting RedundantServerArray failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(redundantServerDataTypeArray);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting RedundantServerArray failed unexpectedly", statusException);
        }
    }
}

