/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.Optional;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.server.NodeManagerUaNode;
import com.prosysopc.ua.types.opcua.TransitionVariableType;
import com.prosysopc.ua.types.opcua.server.BaseDataVariableTypeNode;
import org.opcfoundation.ua.builtintypes.DateTime;
import org.opcfoundation.ua.builtintypes.LocalizedText;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.QualifiedName;
import org.opcfoundation.ua.builtintypes.UnsignedInteger;

public abstract class TransitionVariableTypeNodeBase
extends BaseDataVariableTypeNode
implements TransitionVariableType {
    protected TransitionVariableTypeNodeBase(NodeManagerUaNode nodeManagerUaNode, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        super(nodeManagerUaNode, nodeId, qualifiedName, localizedText);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
    }

    @Override
    @Mandatory
    public UaProperty getIdNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Id");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public Object getId() {
        Object object = this.getIdNode();
        if (object == null) {
            throw new RuntimeException("Mandatory node Id does not exist");
        }
        object = object.getValue().getValue().getValue();
        return object;
    }

    @Override
    @Mandatory
    public void setId(Object object) {
        UaProperty uaProperty = this.getIdNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting Id failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(object);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting Id failed unexpectedly", statusException);
        }
    }

    @Override
    @Optional
    public UaProperty getNameNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Name");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public QualifiedName getName() {
        Object object = this.getNameNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (QualifiedName)object;
    }

    @Override
    @Optional
    public void setName(QualifiedName qualifiedName) {
        UaProperty uaProperty = this.getNameNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting Name failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(qualifiedName);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting Name failed unexpectedly", statusException);
        }
    }

    @Override
    @Optional
    public UaProperty getNumberNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Number");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public UnsignedInteger getNumber() {
        Object object = this.getNumberNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (UnsignedInteger)object;
    }

    @Override
    @Optional
    public void setNumber(UnsignedInteger unsignedInteger) {
        UaProperty uaProperty = this.getNumberNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting Number failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(unsignedInteger);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting Number failed unexpectedly", statusException);
        }
    }

    @Override
    @Optional
    public UaProperty getTransitionTimeNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "TransitionTime");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public DateTime getTransitionTime() {
        Object object = this.getTransitionTimeNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (DateTime)object;
    }

    @Override
    @Optional
    public void setTransitionTime(DateTime dateTime) {
        UaProperty uaProperty = this.getTransitionTimeNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting TransitionTime failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(dateTime);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting TransitionTime failed unexpectedly", statusException);
        }
    }

    @Override
    @Optional
    public UaProperty getEffectiveTransitionTimeNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "EffectiveTransitionTime");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public DateTime getEffectiveTransitionTime() {
        Object object = this.getEffectiveTransitionTimeNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (DateTime)object;
    }

    @Override
    @Optional
    public void setEffectiveTransitionTime(DateTime dateTime) {
        UaProperty uaProperty = this.getEffectiveTransitionTimeNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting EffectiveTransitionTime failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(dateTime);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting EffectiveTransitionTime failed unexpectedly", statusException);
        }
    }
}

