/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.server.NodeManagerUaNode;
import com.prosysopc.ua.types.opcua.TransitionEventType;
import com.prosysopc.ua.types.opcua.server.BaseEventTypeNode;
import com.prosysopc.ua.types.opcua.server.StateVariableTypeNode;
import com.prosysopc.ua.types.opcua.server.TransitionVariableTypeNode;
import org.opcfoundation.ua.builtintypes.LocalizedText;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.QualifiedName;

public abstract class TransitionEventTypeNodeBase
extends BaseEventTypeNode
implements TransitionEventType {
    protected TransitionEventTypeNodeBase(NodeManagerUaNode nodeManagerUaNode, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        super(nodeManagerUaNode, nodeId, qualifiedName, localizedText);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
        this.callAfterCreateIfExists(this.getTransitionNode());
        this.callAfterCreateIfExists(this.getFromStateNode());
        this.callAfterCreateIfExists(this.getToStateNode());
    }

    @Override
    @Mandatory
    public TransitionVariableTypeNode getTransitionNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Transition");
        return (TransitionVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public LocalizedText getTransition() {
        Object object = this.getTransitionNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (LocalizedText)object;
    }

    @Override
    @Mandatory
    public void setTransition(LocalizedText localizedText) {
        TransitionVariableTypeNode transitionVariableTypeNode = this.getTransitionNode();
        if (transitionVariableTypeNode == null) {
            throw new RuntimeException("Setting Transition failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            transitionVariableTypeNode.setValue(localizedText);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting Transition failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public StateVariableTypeNode getFromStateNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "FromState");
        return (StateVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public LocalizedText getFromState() {
        Object object = this.getFromStateNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (LocalizedText)object;
    }

    @Override
    @Mandatory
    public void setFromState(LocalizedText localizedText) {
        StateVariableTypeNode stateVariableTypeNode = this.getFromStateNode();
        if (stateVariableTypeNode == null) {
            throw new RuntimeException("Setting FromState failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            stateVariableTypeNode.setValue(localizedText);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting FromState failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public StateVariableTypeNode getToStateNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ToState");
        return (StateVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public LocalizedText getToState() {
        Object object = this.getToStateNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (LocalizedText)object;
    }

    @Override
    @Mandatory
    public void setToState(LocalizedText localizedText) {
        StateVariableTypeNode stateVariableTypeNode = this.getToStateNode();
        if (stateVariableTypeNode == null) {
            throw new RuntimeException("Setting ToState failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            stateVariableTypeNode.setValue(localizedText);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting ToState failed unexpectedly", statusException);
        }
    }
}

