/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.server.NodeManagerUaNode;
import com.prosysopc.ua.types.opcua.SystemStatusChangeEventType;
import com.prosysopc.ua.types.opcua.server.SystemEventTypeNode;
import org.opcfoundation.ua.builtintypes.LocalizedText;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.QualifiedName;
import org.opcfoundation.ua.core.ServerState;

public abstract class SystemStatusChangeEventTypeNodeBase
extends SystemEventTypeNode
implements SystemStatusChangeEventType {
    protected SystemStatusChangeEventTypeNodeBase(NodeManagerUaNode nodeManagerUaNode, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        super(nodeManagerUaNode, nodeId, qualifiedName, localizedText);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
    }

    @Override
    @Mandatory
    public UaProperty getSystemStateNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "SystemState");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public ServerState getSystemState() {
        Object object = this.getSystemStateNode();
        if (object == null) {
            throw new RuntimeException("Mandatory node SystemState does not exist");
        }
        object = object.getValue().getValue().getValue();
        return ServerState.valueOf((Integer)((Integer)object));
    }

    @Override
    @Mandatory
    public void setSystemState(ServerState serverState) {
        UaProperty uaProperty = this.getSystemStateNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting SystemState failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(serverState);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting SystemState failed unexpectedly", statusException);
        }
    }
}

