/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.SubscriptionBase;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.server.NodeManagerUaNode;
import com.prosysopc.ua.server.Subscription;
import com.prosysopc.ua.server.UaInstantiationException;
import com.prosysopc.ua.types.opcua.SubscriptionDiagnosticsArrayType;
import com.prosysopc.ua.types.opcua.server.SubscriptionDiagnosticsArrayTypeNodeBase;
import com.prosysopc.ua.types.opcua.server.SubscriptionDiagnosticsTypeNode;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.opcfoundation.ua.builtintypes.LocalizedText;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.QualifiedName;
import org.opcfoundation.ua.builtintypes.UnsignedInteger;
import org.opcfoundation.ua.core.Identifiers;
import org.opcfoundation.ua.core.SubscriptionDiagnosticsDataType;
import org.opcfoundation.ua.utils.MultiDimensionArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=2171")
public class SubscriptionDiagnosticsArrayTypeNode
extends SubscriptionDiagnosticsArrayTypeNodeBase {
    private static final Logger logger = LoggerFactory.getLogger(SubscriptionDiagnosticsArrayType.class);
    private final List<SubscriptionDiagnosticsTypeNode> ci = new CopyOnWriteArrayList<SubscriptionDiagnosticsTypeNode>();

    protected SubscriptionDiagnosticsArrayTypeNode(NodeManagerUaNode nodeManagerUaNode, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        super(nodeManagerUaNode, nodeId, qualifiedName, localizedText);
    }

    public void addSubscription(Subscription subscription) {
        SubscriptionDiagnosticsTypeNode subscriptionDiagnosticsTypeNode;
        try {
            subscriptionDiagnosticsTypeNode = this.getNodeManager().createInstance(SubscriptionDiagnosticsTypeNode.class, subscription.getSubscriptionId().toString(), NodeId.randomGUID((int)this.getNodeManager().getNamespaceIndex()));
        }
        catch (UaInstantiationException uaInstantiationException) {
            throw new RuntimeException(uaInstantiationException);
        }
        subscriptionDiagnosticsTypeNode.setSubscription(subscription);
        this.ci.add(subscriptionDiagnosticsTypeNode);
        this.addComponent(subscriptionDiagnosticsTypeNode);
        if (logger.isDebugEnabled()) {
            logger.debug("Created SubscriptoionDiagnosticsTypeNode node:" + MultiDimensionArrayUtils.toString((Object)subscriptionDiagnosticsTypeNode));
        }
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
        SubscriptionDiagnosticsDataType[] subscriptionDiagnosticsDataTypeArray = new SubscriptionDiagnosticsDataType[]{};
        try {
            this.setValue(subscriptionDiagnosticsDataTypeArray);
        }
        catch (StatusException statusException) {
            throw new RuntimeException(statusException);
        }
        this.setDataTypeId(Identifiers.SubscriptionDiagnosticsDataType);
        this.setArrayDimensions(new UnsignedInteger[]{UnsignedInteger.ZERO});
        this.setValueRank(1);
    }

    public void removeSubscription(Subscription object) {
        object = new QualifiedName(1, ((SubscriptionBase)object).getSubscriptionId().toString());
        if (logger.isDebugEnabled()) {
            logger.debug("removeSubscription, name=" + object);
        }
        if ((object = this.getComponent((QualifiedName)object)) == null) {
            return;
        }
        this.ci.remove(object);
        this.removeComponent((UaNode)object);
        try {
            this.getNodeManager().deleteNode((UaNode)object, true, true);
        }
        catch (StatusException statusException) {
            logger.info("Deleting subscription diagnostics node failed", (Throwable)statusException);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Removed SubscriptionDiagnosticsType node:" + MultiDimensionArrayUtils.toString((Object)object));
        }
    }
}

