/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.Optional;
import com.prosysopc.ua.server.NodeManagerUaNode;
import com.prosysopc.ua.types.opcua.StateMachineType;
import com.prosysopc.ua.types.opcua.server.BaseObjectTypeNode;
import com.prosysopc.ua.types.opcua.server.StateVariableTypeNode;
import com.prosysopc.ua.types.opcua.server.TransitionVariableTypeNode;
import org.opcfoundation.ua.builtintypes.LocalizedText;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.QualifiedName;

public abstract class StateMachineTypeNodeBase
extends BaseObjectTypeNode
implements StateMachineType {
    protected StateMachineTypeNodeBase(NodeManagerUaNode nodeManagerUaNode, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        super(nodeManagerUaNode, nodeId, qualifiedName, localizedText);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
        this.callAfterCreateIfExists(this.getCurrentStateNode());
        this.callAfterCreateIfExists(this.getLastTransitionNode());
    }

    @Override
    @Mandatory
    public StateVariableTypeNode getCurrentStateNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "CurrentState");
        return (StateVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public LocalizedText getCurrentState() {
        Object object = this.getCurrentStateNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (LocalizedText)object;
    }

    @Override
    @Mandatory
    public void setCurrentState(LocalizedText localizedText) {
        StateVariableTypeNode stateVariableTypeNode = this.getCurrentStateNode();
        if (stateVariableTypeNode == null) {
            throw new RuntimeException("Setting CurrentState failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            stateVariableTypeNode.setValue(localizedText);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting CurrentState failed unexpectedly", statusException);
        }
    }

    @Override
    @Optional
    public TransitionVariableTypeNode getLastTransitionNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "LastTransition");
        return (TransitionVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Optional
    public LocalizedText getLastTransition() {
        Object object = this.getLastTransitionNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (LocalizedText)object;
    }

    @Override
    @Optional
    public void setLastTransition(LocalizedText localizedText) {
        TransitionVariableTypeNode transitionVariableTypeNode = this.getLastTransitionNode();
        if (transitionVariableTypeNode == null) {
            throw new RuntimeException("Setting LastTransition failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            transitionVariableTypeNode.setValue(localizedText);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting LastTransition failed unexpectedly", statusException);
        }
    }
}

