/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.server.NodeManagerUaNode;
import com.prosysopc.ua.server.ServiceContext;
import com.prosysopc.ua.types.opcua.ShelvedStateMachineType;
import com.prosysopc.ua.types.opcua.server.FiniteStateMachineTypeNode;
import org.opcfoundation.ua.builtintypes.DiagnosticInfo;
import org.opcfoundation.ua.builtintypes.LocalizedText;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.QualifiedName;
import org.opcfoundation.ua.builtintypes.StatusCode;
import org.opcfoundation.ua.builtintypes.Variant;

public abstract class ShelvedStateMachineTypeNodeBase
extends FiniteStateMachineTypeNode
implements ShelvedStateMachineType {
    protected ShelvedStateMachineTypeNodeBase(NodeManagerUaNode nodeManagerUaNode, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        super(nodeManagerUaNode, nodeId, qualifiedName, localizedText);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
    }

    @Override
    @Mandatory
    public UaProperty getUnshelveTimeNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "UnshelveTime");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public Double getUnshelveTime() {
        Object object = this.getUnshelveTimeNode();
        if (object == null) {
            throw new RuntimeException("Mandatory node UnshelveTime does not exist");
        }
        object = object.getValue().getValue().getValue();
        return (Double)object;
    }

    @Override
    @Mandatory
    public void setUnshelveTime(Double d2) {
        UaProperty uaProperty = this.getUnshelveTimeNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting UnshelveTime failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(d2);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting UnshelveTime failed unexpectedly", statusException);
        }
    }

    @Override
    public Variant[] callMethod(ServiceContext serviceContext, NodeId nodeId, Variant[] variantArray, StatusCode[] statusCodeArray, DiagnosticInfo[] diagnosticInfoArray) throws StatusException {
        Object object = this.getQualifiedName("http://opcfoundation.org/UA/", "Unshelve");
        if ((object = this.getComponent((QualifiedName)object)) != null && object.getNodeId().equals((Object)nodeId)) {
            this.onUnshelve(serviceContext);
            return null;
        }
        object = this.getQualifiedName("http://opcfoundation.org/UA/", "OneShotShelve");
        if ((object = this.getComponent((QualifiedName)object)) != null && object.getNodeId().equals((Object)nodeId)) {
            this.onOneShotShelve(serviceContext);
            return null;
        }
        object = this.getQualifiedName("http://opcfoundation.org/UA/", "TimedShelve");
        if ((object = this.getComponent((QualifiedName)object)) != null && object.getNodeId().equals((Object)nodeId)) {
            this.onTimedShelve(serviceContext, (Double)variantArray[0].getValue());
            return null;
        }
        return super.callMethod(serviceContext, nodeId, variantArray, statusCodeArray, diagnosticInfoArray);
    }

    @Override
    public void unshelve() throws StatusException {
        this.onUnshelve(ServiceContext.INTERNAL_OPERATION_CONTEXT);
    }

    protected abstract void onUnshelve(ServiceContext var1) throws StatusException;

    @Override
    public void oneShotShelve() throws StatusException {
        this.onOneShotShelve(ServiceContext.INTERNAL_OPERATION_CONTEXT);
    }

    protected abstract void onOneShotShelve(ServiceContext var1) throws StatusException;

    @Override
    public void timedShelve(Double d2) throws StatusException {
        this.onTimedShelve(ServiceContext.INTERNAL_OPERATION_CONTEXT, d2);
    }

    protected abstract void onTimedShelve(ServiceContext var1, Double var2) throws StatusException;
}

