/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.server.NodeManagerUaNode;
import com.prosysopc.ua.server.ServiceContext;
import com.prosysopc.ua.types.opcua.server.AlarmConditionTypeNode;
import com.prosysopc.ua.types.opcua.server.ShelvedStateMachineTypeNodeBase;
import java.util.Timer;
import java.util.TimerTask;
import org.opcfoundation.ua.builtintypes.LocalizedText;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.QualifiedName;
import org.opcfoundation.ua.core.Identifiers;
import org.opcfoundation.ua.core.StatusCodes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=2929")
public class ShelvedStateMachineTypeNode
extends ShelvedStateMachineTypeNodeBase {
    private static final Logger logger = LoggerFactory.getLogger(ShelvedStateMachineTypeNode.class);
    private AlarmConditionTypeNode jR;
    private long jS;
    private Timer jT;

    protected ShelvedStateMachineTypeNode(NodeManagerUaNode nodeManagerUaNode, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        super(nodeManagerUaNode, nodeId, qualifiedName, localizedText);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
        this.getCurrentStateNode().setId(Identifiers.ShelvedStateMachineType_Unshelved);
    }

    public AlarmConditionTypeNode getCondition() {
        return this.jR;
    }

    @Override
    public Double getUnshelveTime() {
        long l2 = this.jS - System.currentTimeMillis();
        return l2 > 0L ? (double)l2 : 0.0;
    }

    public boolean isOneshotShelved() {
        return NodeId.equals((NodeId)this.getCurrentStateNode().getId(), (NodeId)Identifiers.ShelvedStateMachineType_OneShotShelved);
    }

    public boolean isShelved() {
        return !NodeId.equals((NodeId)this.getCurrentStateNode().getId(), (NodeId)Identifiers.ShelvedStateMachineType_Unshelved);
    }

    public void setCondition(AlarmConditionTypeNode alarmConditionTypeNode) {
        this.jR = alarmConditionTypeNode;
    }

    @Override
    protected void onOneShotShelve(ServiceContext serviceContext) throws StatusException {
        serviceContext = this.getCurrentStateNode().getId();
        if (Identifiers.ShelvedStateMachineType_OneShotShelved.equals((Object)serviceContext)) {
            return;
        }
        this.getCurrentStateNode().setId(Identifiers.ShelvedStateMachineType_OneShotShelved);
        if (Identifiers.ShelvedStateMachineType_TimedShelved.equals((Object)serviceContext)) {
            this.jT.cancel();
            this.getLastTransitionNode().setId(Identifiers.ShelvedStateMachineType_TimedShelvedToOneShotShelved);
        }
        if (Identifiers.ShelvedStateMachineType_Unshelved.equals((Object)serviceContext)) {
            this.getLastTransitionNode().setId(Identifiers.ShelvedStateMachineType_UnshelvedToOneShotShelved);
        }
    }

    @Override
    protected void onTimedShelve(ServiceContext serviceContext, Double d2) throws StatusException {
        serviceContext = this.getCurrentStateNode().getId();
        if (Identifiers.ShelvedStateMachineType_TimedShelved.equals((Object)serviceContext)) {
            throw new StatusException(StatusCodes.Bad_ConditionAlreadyShelved);
        }
        long l2 = (long)Math.ceil(d2);
        this.getCurrentStateNode().setId(Identifiers.ShelvedStateMachineType_TimedShelved);
        if (this.jT == null) {
            this.jT = new Timer("UnshelveTimer");
        }
        try {
            this.jT.schedule((TimerTask)new UnshelveTask(this, this), l2);
            this.jS = System.currentTimeMillis() + l2;
            logger.info("TimedShelve started: NodeId=" + this.getNodeId());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new StatusException(StatusCodes.Bad_ShelvingTimeOutOfRange);
        }
        if (Identifiers.ShelvedStateMachineType_OneShotShelved.equals((Object)serviceContext)) {
            this.getLastTransitionNode().setId(Identifiers.ShelvedStateMachineType_OneShotShelvedToTimedShelved);
        }
        if (Identifiers.ShelvedStateMachineType_Unshelved.equals((Object)serviceContext)) {
            this.getLastTransitionNode().setId(Identifiers.ShelvedStateMachineType_UnshelvedToTimedShelved);
        }
    }

    @Override
    protected void onUnshelve(ServiceContext serviceContext) throws StatusException {
        serviceContext = this.getCurrentStateNode().getId();
        if (Identifiers.ShelvedStateMachineType_Unshelved.equals((Object)serviceContext)) {
            return;
        }
        this.getCurrentStateNode().setId(Identifiers.ShelvedStateMachineType_Unshelved);
        if (Identifiers.ShelvedStateMachineType_OneShotShelved.equals((Object)serviceContext)) {
            this.getLastTransitionNode().setId(Identifiers.ShelvedStateMachineType_OneShotShelvedToUnshelved);
        }
        if (Identifiers.ShelvedStateMachineType_TimedShelved.equals((Object)serviceContext)) {
            this.jT.cancel();
            this.getLastTransitionNode().setId(Identifiers.ShelvedStateMachineType_TimedShelvedToUnshelved);
            this.jT = null;
        }
    }

    public class UnshelveTask
    extends TimerTask {
        private final ShelvedStateMachineTypeNode dY;

        public UnshelveTask(ShelvedStateMachineTypeNode shelvedStateMachineTypeNode, ShelvedStateMachineTypeNode shelvedStateMachineTypeNode2) {
            this.dY = shelvedStateMachineTypeNode2;
        }

        @Override
        public void run() {
            try {
                this.dY.unshelve();
                logger.info("TimedShelve ended: NodeId=" + this.dY.getNodeId());
                return;
            }
            catch (StatusException statusException) {
                logger.error("Timed unshelving failed: " + statusException);
                return;
            }
        }
    }
}

