/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.server.NodeManagerUaNode;
import com.prosysopc.ua.types.opcua.SessionsDiagnosticsSummaryType;
import com.prosysopc.ua.types.opcua.server.BaseObjectTypeNode;
import com.prosysopc.ua.types.opcua.server.SessionDiagnosticsArrayTypeNode;
import com.prosysopc.ua.types.opcua.server.SessionSecurityDiagnosticsArrayTypeNode;
import org.opcfoundation.ua.builtintypes.LocalizedText;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.QualifiedName;
import org.opcfoundation.ua.core.SessionDiagnosticsDataType;
import org.opcfoundation.ua.core.SessionSecurityDiagnosticsDataType;

public abstract class SessionsDiagnosticsSummaryTypeNodeBase
extends BaseObjectTypeNode
implements SessionsDiagnosticsSummaryType {
    protected SessionsDiagnosticsSummaryTypeNodeBase(NodeManagerUaNode nodeManagerUaNode, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        super(nodeManagerUaNode, nodeId, qualifiedName, localizedText);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
        this.callAfterCreateIfExists(this.getSessionDiagnosticsArrayNode());
        this.callAfterCreateIfExists(this.getSessionSecurityDiagnosticsArrayNode());
    }

    @Override
    @Mandatory
    public SessionDiagnosticsArrayTypeNode getSessionDiagnosticsArrayNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "SessionDiagnosticsArray");
        return (SessionDiagnosticsArrayTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public SessionDiagnosticsDataType[] getSessionDiagnosticsArray() {
        Object object = this.getSessionDiagnosticsArrayNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (SessionDiagnosticsDataType[])object;
    }

    @Override
    @Mandatory
    public void setSessionDiagnosticsArray(SessionDiagnosticsDataType[] sessionDiagnosticsDataTypeArray) {
        SessionDiagnosticsArrayTypeNode sessionDiagnosticsArrayTypeNode = this.getSessionDiagnosticsArrayNode();
        if (sessionDiagnosticsArrayTypeNode == null) {
            throw new RuntimeException("Setting SessionDiagnosticsArray failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            sessionDiagnosticsArrayTypeNode.setValue(sessionDiagnosticsDataTypeArray);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting SessionDiagnosticsArray failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public SessionSecurityDiagnosticsArrayTypeNode getSessionSecurityDiagnosticsArrayNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "SessionSecurityDiagnosticsArray");
        return (SessionSecurityDiagnosticsArrayTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public SessionSecurityDiagnosticsDataType[] getSessionSecurityDiagnosticsArray() {
        Object object = this.getSessionSecurityDiagnosticsArrayNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (SessionSecurityDiagnosticsDataType[])object;
    }

    @Override
    @Mandatory
    public void setSessionSecurityDiagnosticsArray(SessionSecurityDiagnosticsDataType[] sessionSecurityDiagnosticsDataTypeArray) {
        SessionSecurityDiagnosticsArrayTypeNode sessionSecurityDiagnosticsArrayTypeNode = this.getSessionSecurityDiagnosticsArrayNode();
        if (sessionSecurityDiagnosticsArrayTypeNode == null) {
            throw new RuntimeException("Setting SessionSecurityDiagnosticsArray failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            sessionSecurityDiagnosticsArrayTypeNode.setValue(sessionSecurityDiagnosticsDataTypeArray);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting SessionSecurityDiagnosticsArray failed unexpectedly", statusException);
        }
    }
}

