/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.server.NodeManagerUaNode;
import com.prosysopc.ua.types.opcua.SessionSecurityDiagnosticsType;
import com.prosysopc.ua.types.opcua.server.BaseDataVariableTypeNode;
import org.opcfoundation.ua.builtintypes.LocalizedText;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.QualifiedName;
import org.opcfoundation.ua.core.MessageSecurityMode;

public abstract class SessionSecurityDiagnosticsTypeNodeBase
extends BaseDataVariableTypeNode
implements SessionSecurityDiagnosticsType {
    protected SessionSecurityDiagnosticsTypeNodeBase(NodeManagerUaNode nodeManagerUaNode, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        super(nodeManagerUaNode, nodeId, qualifiedName, localizedText);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
        this.callAfterCreateIfExists(this.getSessionIdNode());
        this.callAfterCreateIfExists(this.getClientUserIdOfSessionNode());
        this.callAfterCreateIfExists(this.getClientUserIdHistoryNode());
        this.callAfterCreateIfExists(this.getAuthenticationMechanismNode());
        this.callAfterCreateIfExists(this.getEncodingNode());
        this.callAfterCreateIfExists(this.getTransportProtocolNode());
        this.callAfterCreateIfExists(this.getSecurityModeNode());
        this.callAfterCreateIfExists(this.getSecurityPolicyUriNode());
        this.callAfterCreateIfExists(this.getClientCertificateNode());
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getSessionIdNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "SessionId");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public NodeId getSessionId() {
        Object object = this.getSessionIdNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (NodeId)object;
    }

    @Override
    @Mandatory
    public void setSessionId(NodeId nodeId) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getSessionIdNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting SessionId failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(nodeId);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting SessionId failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getClientUserIdOfSessionNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ClientUserIdOfSession");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public String getClientUserIdOfSession() {
        Object object = this.getClientUserIdOfSessionNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (String)object;
    }

    @Override
    @Mandatory
    public void setClientUserIdOfSession(String string) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getClientUserIdOfSessionNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting ClientUserIdOfSession failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(string);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting ClientUserIdOfSession failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getClientUserIdHistoryNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ClientUserIdHistory");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public String[] getClientUserIdHistory() {
        Object object = this.getClientUserIdHistoryNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (String[])object;
    }

    @Override
    @Mandatory
    public void setClientUserIdHistory(String[] stringArray) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getClientUserIdHistoryNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting ClientUserIdHistory failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(stringArray);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting ClientUserIdHistory failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getAuthenticationMechanismNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "AuthenticationMechanism");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public String getAuthenticationMechanism() {
        Object object = this.getAuthenticationMechanismNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (String)object;
    }

    @Override
    @Mandatory
    public void setAuthenticationMechanism(String string) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getAuthenticationMechanismNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting AuthenticationMechanism failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(string);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting AuthenticationMechanism failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getEncodingNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Encoding");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public String getEncoding() {
        Object object = this.getEncodingNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (String)object;
    }

    @Override
    @Mandatory
    public void setEncoding(String string) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getEncodingNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting Encoding failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(string);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting Encoding failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getTransportProtocolNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "TransportProtocol");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public String getTransportProtocol() {
        Object object = this.getTransportProtocolNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (String)object;
    }

    @Override
    @Mandatory
    public void setTransportProtocol(String string) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getTransportProtocolNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting TransportProtocol failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(string);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting TransportProtocol failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getSecurityModeNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "SecurityMode");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public MessageSecurityMode getSecurityMode() {
        Object object = this.getSecurityModeNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return MessageSecurityMode.valueOf((int)((Integer)object));
    }

    @Override
    @Mandatory
    public void setSecurityMode(MessageSecurityMode messageSecurityMode) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getSecurityModeNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting SecurityMode failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(messageSecurityMode);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting SecurityMode failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getSecurityPolicyUriNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "SecurityPolicyUri");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public String getSecurityPolicyUri() {
        Object object = this.getSecurityPolicyUriNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (String)object;
    }

    @Override
    @Mandatory
    public void setSecurityPolicyUri(String string) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getSecurityPolicyUriNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting SecurityPolicyUri failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(string);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting SecurityPolicyUri failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getClientCertificateNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ClientCertificate");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public byte[] getClientCertificate() {
        Object object = this.getClientCertificateNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (byte[])object;
    }

    @Override
    @Mandatory
    public void setClientCertificate(byte[] byArray) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getClientCertificateNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting ClientCertificate failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(byArray);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting ClientCertificate failed unexpectedly", statusException);
        }
    }
}

