/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.server.NodeManagerUaNode;
import com.prosysopc.ua.types.opcua.SessionDiagnosticsVariableType;
import com.prosysopc.ua.types.opcua.server.BaseDataVariableTypeNode;
import org.opcfoundation.ua.builtintypes.DateTime;
import org.opcfoundation.ua.builtintypes.LocalizedText;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.QualifiedName;
import org.opcfoundation.ua.builtintypes.UnsignedInteger;
import org.opcfoundation.ua.core.ApplicationDescription;
import org.opcfoundation.ua.core.ServiceCounterDataType;

public abstract class SessionDiagnosticsVariableTypeNodeBase
extends BaseDataVariableTypeNode
implements SessionDiagnosticsVariableType {
    protected SessionDiagnosticsVariableTypeNodeBase(NodeManagerUaNode nodeManagerUaNode, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        super(nodeManagerUaNode, nodeId, qualifiedName, localizedText);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
        this.callAfterCreateIfExists(this.getSessionIdNode());
        this.callAfterCreateIfExists(this.getSessionNameNode());
        this.callAfterCreateIfExists(this.getClientDescriptionNode());
        this.callAfterCreateIfExists(this.getServerUriNode());
        this.callAfterCreateIfExists(this.getEndpointUrlNode());
        this.callAfterCreateIfExists(this.getLocaleIdsNode());
        this.callAfterCreateIfExists(this.getActualSessionTimeoutNode());
        this.callAfterCreateIfExists(this.getMaxResponseMessageSizeNode());
        this.callAfterCreateIfExists(this.getClientConnectionTimeNode());
        this.callAfterCreateIfExists(this.getClientLastContactTimeNode());
        this.callAfterCreateIfExists(this.getCurrentSubscriptionsCountNode());
        this.callAfterCreateIfExists(this.getCurrentMonitoredItemsCountNode());
        this.callAfterCreateIfExists(this.getCurrentPublishRequestsInQueueNode());
        this.callAfterCreateIfExists(this.getTotalRequestCountNode());
        this.callAfterCreateIfExists(this.getUnauthorizedRequestCountNode());
        this.callAfterCreateIfExists(this.getReadCountNode());
        this.callAfterCreateIfExists(this.getHistoryReadCountNode());
        this.callAfterCreateIfExists(this.getWriteCountNode());
        this.callAfterCreateIfExists(this.getHistoryUpdateCountNode());
        this.callAfterCreateIfExists(this.getCallCountNode());
        this.callAfterCreateIfExists(this.getCreateMonitoredItemsCountNode());
        this.callAfterCreateIfExists(this.getModifyMonitoredItemsCountNode());
        this.callAfterCreateIfExists(this.getSetMonitoringModeCountNode());
        this.callAfterCreateIfExists(this.getSetTriggeringCountNode());
        this.callAfterCreateIfExists(this.getDeleteMonitoredItemsCountNode());
        this.callAfterCreateIfExists(this.getCreateSubscriptionCountNode());
        this.callAfterCreateIfExists(this.getModifySubscriptionCountNode());
        this.callAfterCreateIfExists(this.getSetPublishingModeCountNode());
        this.callAfterCreateIfExists(this.getPublishCountNode());
        this.callAfterCreateIfExists(this.getRepublishCountNode());
        this.callAfterCreateIfExists(this.getTransferSubscriptionsCountNode());
        this.callAfterCreateIfExists(this.getDeleteSubscriptionsCountNode());
        this.callAfterCreateIfExists(this.getAddNodesCountNode());
        this.callAfterCreateIfExists(this.getAddReferencesCountNode());
        this.callAfterCreateIfExists(this.getDeleteNodesCountNode());
        this.callAfterCreateIfExists(this.getDeleteReferencesCountNode());
        this.callAfterCreateIfExists(this.getBrowseCountNode());
        this.callAfterCreateIfExists(this.getBrowseNextCountNode());
        this.callAfterCreateIfExists(this.getTranslateBrowsePathsToNodeIdsCountNode());
        this.callAfterCreateIfExists(this.getQueryFirstCountNode());
        this.callAfterCreateIfExists(this.getQueryNextCountNode());
        this.callAfterCreateIfExists(this.getRegisterNodesCountNode());
        this.callAfterCreateIfExists(this.getUnregisterNodesCountNode());
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getSessionIdNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "SessionId");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public NodeId getSessionId() {
        Object object = this.getSessionIdNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (NodeId)object;
    }

    @Override
    @Mandatory
    public void setSessionId(NodeId nodeId) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getSessionIdNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting SessionId failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(nodeId);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting SessionId failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getSessionNameNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "SessionName");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public String getSessionName() {
        Object object = this.getSessionNameNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (String)object;
    }

    @Override
    @Mandatory
    public void setSessionName(String string) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getSessionNameNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting SessionName failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(string);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting SessionName failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getClientDescriptionNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ClientDescription");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public ApplicationDescription getClientDescription() {
        Object object = this.getClientDescriptionNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (ApplicationDescription)object;
    }

    @Override
    @Mandatory
    public void setClientDescription(ApplicationDescription applicationDescription) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getClientDescriptionNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting ClientDescription failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(applicationDescription);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting ClientDescription failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getServerUriNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ServerUri");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public String getServerUri() {
        Object object = this.getServerUriNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (String)object;
    }

    @Override
    @Mandatory
    public void setServerUri(String string) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getServerUriNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting ServerUri failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(string);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting ServerUri failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getEndpointUrlNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "EndpointUrl");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public String getEndpointUrl() {
        Object object = this.getEndpointUrlNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (String)object;
    }

    @Override
    @Mandatory
    public void setEndpointUrl(String string) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getEndpointUrlNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting EndpointUrl failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(string);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting EndpointUrl failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getLocaleIdsNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "LocaleIds");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public String[] getLocaleIds() {
        Object object = this.getLocaleIdsNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (String[])object;
    }

    @Override
    @Mandatory
    public void setLocaleIds(String[] stringArray) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getLocaleIdsNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting LocaleIds failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(stringArray);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting LocaleIds failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getActualSessionTimeoutNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ActualSessionTimeout");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public Double getActualSessionTimeout() {
        Object object = this.getActualSessionTimeoutNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (Double)object;
    }

    @Override
    @Mandatory
    public void setActualSessionTimeout(Double d2) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getActualSessionTimeoutNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting ActualSessionTimeout failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(d2);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting ActualSessionTimeout failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getMaxResponseMessageSizeNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "MaxResponseMessageSize");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public UnsignedInteger getMaxResponseMessageSize() {
        Object object = this.getMaxResponseMessageSizeNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (UnsignedInteger)object;
    }

    @Override
    @Mandatory
    public void setMaxResponseMessageSize(UnsignedInteger unsignedInteger) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getMaxResponseMessageSizeNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting MaxResponseMessageSize failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(unsignedInteger);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting MaxResponseMessageSize failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getClientConnectionTimeNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ClientConnectionTime");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public DateTime getClientConnectionTime() {
        Object object = this.getClientConnectionTimeNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (DateTime)object;
    }

    @Override
    @Mandatory
    public void setClientConnectionTime(DateTime dateTime) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getClientConnectionTimeNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting ClientConnectionTime failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(dateTime);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting ClientConnectionTime failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getClientLastContactTimeNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ClientLastContactTime");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public DateTime getClientLastContactTime() {
        Object object = this.getClientLastContactTimeNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (DateTime)object;
    }

    @Override
    @Mandatory
    public void setClientLastContactTime(DateTime dateTime) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getClientLastContactTimeNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting ClientLastContactTime failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(dateTime);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting ClientLastContactTime failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getCurrentSubscriptionsCountNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "CurrentSubscriptionsCount");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public UnsignedInteger getCurrentSubscriptionsCount() {
        Object object = this.getCurrentSubscriptionsCountNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (UnsignedInteger)object;
    }

    @Override
    @Mandatory
    public void setCurrentSubscriptionsCount(UnsignedInteger unsignedInteger) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getCurrentSubscriptionsCountNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting CurrentSubscriptionsCount failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(unsignedInteger);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting CurrentSubscriptionsCount failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getCurrentMonitoredItemsCountNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "CurrentMonitoredItemsCount");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public UnsignedInteger getCurrentMonitoredItemsCount() {
        Object object = this.getCurrentMonitoredItemsCountNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (UnsignedInteger)object;
    }

    @Override
    @Mandatory
    public void setCurrentMonitoredItemsCount(UnsignedInteger unsignedInteger) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getCurrentMonitoredItemsCountNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting CurrentMonitoredItemsCount failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(unsignedInteger);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting CurrentMonitoredItemsCount failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getCurrentPublishRequestsInQueueNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "CurrentPublishRequestsInQueue");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public UnsignedInteger getCurrentPublishRequestsInQueue() {
        Object object = this.getCurrentPublishRequestsInQueueNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (UnsignedInteger)object;
    }

    @Override
    @Mandatory
    public void setCurrentPublishRequestsInQueue(UnsignedInteger unsignedInteger) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getCurrentPublishRequestsInQueueNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting CurrentPublishRequestsInQueue failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(unsignedInteger);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting CurrentPublishRequestsInQueue failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getTotalRequestCountNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "TotalRequestCount");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public ServiceCounterDataType getTotalRequestCount() {
        Object object = this.getTotalRequestCountNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (ServiceCounterDataType)object;
    }

    @Override
    @Mandatory
    public void setTotalRequestCount(ServiceCounterDataType serviceCounterDataType) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getTotalRequestCountNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting TotalRequestCount failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(serviceCounterDataType);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting TotalRequestCount failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getUnauthorizedRequestCountNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "UnauthorizedRequestCount");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public UnsignedInteger getUnauthorizedRequestCount() {
        Object object = this.getUnauthorizedRequestCountNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (UnsignedInteger)object;
    }

    @Override
    @Mandatory
    public void setUnauthorizedRequestCount(UnsignedInteger unsignedInteger) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getUnauthorizedRequestCountNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting UnauthorizedRequestCount failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(unsignedInteger);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting UnauthorizedRequestCount failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getReadCountNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ReadCount");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public ServiceCounterDataType getReadCount() {
        Object object = this.getReadCountNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (ServiceCounterDataType)object;
    }

    @Override
    @Mandatory
    public void setReadCount(ServiceCounterDataType serviceCounterDataType) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getReadCountNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting ReadCount failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(serviceCounterDataType);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting ReadCount failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getHistoryReadCountNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "HistoryReadCount");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public ServiceCounterDataType getHistoryReadCount() {
        Object object = this.getHistoryReadCountNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (ServiceCounterDataType)object;
    }

    @Override
    @Mandatory
    public void setHistoryReadCount(ServiceCounterDataType serviceCounterDataType) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getHistoryReadCountNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting HistoryReadCount failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(serviceCounterDataType);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting HistoryReadCount failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getWriteCountNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "WriteCount");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public ServiceCounterDataType getWriteCount() {
        Object object = this.getWriteCountNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (ServiceCounterDataType)object;
    }

    @Override
    @Mandatory
    public void setWriteCount(ServiceCounterDataType serviceCounterDataType) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getWriteCountNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting WriteCount failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(serviceCounterDataType);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting WriteCount failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getHistoryUpdateCountNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "HistoryUpdateCount");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public ServiceCounterDataType getHistoryUpdateCount() {
        Object object = this.getHistoryUpdateCountNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (ServiceCounterDataType)object;
    }

    @Override
    @Mandatory
    public void setHistoryUpdateCount(ServiceCounterDataType serviceCounterDataType) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getHistoryUpdateCountNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting HistoryUpdateCount failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(serviceCounterDataType);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting HistoryUpdateCount failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getCallCountNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "CallCount");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public ServiceCounterDataType getCallCount() {
        Object object = this.getCallCountNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (ServiceCounterDataType)object;
    }

    @Override
    @Mandatory
    public void setCallCount(ServiceCounterDataType serviceCounterDataType) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getCallCountNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting CallCount failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(serviceCounterDataType);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting CallCount failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getCreateMonitoredItemsCountNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "CreateMonitoredItemsCount");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public ServiceCounterDataType getCreateMonitoredItemsCount() {
        Object object = this.getCreateMonitoredItemsCountNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (ServiceCounterDataType)object;
    }

    @Override
    @Mandatory
    public void setCreateMonitoredItemsCount(ServiceCounterDataType serviceCounterDataType) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getCreateMonitoredItemsCountNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting CreateMonitoredItemsCount failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(serviceCounterDataType);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting CreateMonitoredItemsCount failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getModifyMonitoredItemsCountNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ModifyMonitoredItemsCount");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public ServiceCounterDataType getModifyMonitoredItemsCount() {
        Object object = this.getModifyMonitoredItemsCountNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (ServiceCounterDataType)object;
    }

    @Override
    @Mandatory
    public void setModifyMonitoredItemsCount(ServiceCounterDataType serviceCounterDataType) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getModifyMonitoredItemsCountNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting ModifyMonitoredItemsCount failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(serviceCounterDataType);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting ModifyMonitoredItemsCount failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getSetMonitoringModeCountNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "SetMonitoringModeCount");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public ServiceCounterDataType getSetMonitoringModeCount() {
        Object object = this.getSetMonitoringModeCountNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (ServiceCounterDataType)object;
    }

    @Override
    @Mandatory
    public void setSetMonitoringModeCount(ServiceCounterDataType serviceCounterDataType) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getSetMonitoringModeCountNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting SetMonitoringModeCount failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(serviceCounterDataType);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting SetMonitoringModeCount failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getSetTriggeringCountNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "SetTriggeringCount");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public ServiceCounterDataType getSetTriggeringCount() {
        Object object = this.getSetTriggeringCountNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (ServiceCounterDataType)object;
    }

    @Override
    @Mandatory
    public void setSetTriggeringCount(ServiceCounterDataType serviceCounterDataType) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getSetTriggeringCountNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting SetTriggeringCount failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(serviceCounterDataType);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting SetTriggeringCount failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getDeleteMonitoredItemsCountNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "DeleteMonitoredItemsCount");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public ServiceCounterDataType getDeleteMonitoredItemsCount() {
        Object object = this.getDeleteMonitoredItemsCountNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (ServiceCounterDataType)object;
    }

    @Override
    @Mandatory
    public void setDeleteMonitoredItemsCount(ServiceCounterDataType serviceCounterDataType) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getDeleteMonitoredItemsCountNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting DeleteMonitoredItemsCount failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(serviceCounterDataType);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting DeleteMonitoredItemsCount failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getCreateSubscriptionCountNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "CreateSubscriptionCount");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public ServiceCounterDataType getCreateSubscriptionCount() {
        Object object = this.getCreateSubscriptionCountNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (ServiceCounterDataType)object;
    }

    @Override
    @Mandatory
    public void setCreateSubscriptionCount(ServiceCounterDataType serviceCounterDataType) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getCreateSubscriptionCountNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting CreateSubscriptionCount failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(serviceCounterDataType);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting CreateSubscriptionCount failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getModifySubscriptionCountNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ModifySubscriptionCount");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public ServiceCounterDataType getModifySubscriptionCount() {
        Object object = this.getModifySubscriptionCountNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (ServiceCounterDataType)object;
    }

    @Override
    @Mandatory
    public void setModifySubscriptionCount(ServiceCounterDataType serviceCounterDataType) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getModifySubscriptionCountNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting ModifySubscriptionCount failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(serviceCounterDataType);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting ModifySubscriptionCount failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getSetPublishingModeCountNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "SetPublishingModeCount");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public ServiceCounterDataType getSetPublishingModeCount() {
        Object object = this.getSetPublishingModeCountNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (ServiceCounterDataType)object;
    }

    @Override
    @Mandatory
    public void setSetPublishingModeCount(ServiceCounterDataType serviceCounterDataType) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getSetPublishingModeCountNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting SetPublishingModeCount failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(serviceCounterDataType);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting SetPublishingModeCount failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getPublishCountNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "PublishCount");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public ServiceCounterDataType getPublishCount() {
        Object object = this.getPublishCountNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (ServiceCounterDataType)object;
    }

    @Override
    @Mandatory
    public void setPublishCount(ServiceCounterDataType serviceCounterDataType) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getPublishCountNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting PublishCount failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(serviceCounterDataType);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting PublishCount failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getRepublishCountNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "RepublishCount");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public ServiceCounterDataType getRepublishCount() {
        Object object = this.getRepublishCountNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (ServiceCounterDataType)object;
    }

    @Override
    @Mandatory
    public void setRepublishCount(ServiceCounterDataType serviceCounterDataType) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getRepublishCountNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting RepublishCount failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(serviceCounterDataType);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting RepublishCount failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getTransferSubscriptionsCountNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "TransferSubscriptionsCount");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public ServiceCounterDataType getTransferSubscriptionsCount() {
        Object object = this.getTransferSubscriptionsCountNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (ServiceCounterDataType)object;
    }

    @Override
    @Mandatory
    public void setTransferSubscriptionsCount(ServiceCounterDataType serviceCounterDataType) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getTransferSubscriptionsCountNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting TransferSubscriptionsCount failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(serviceCounterDataType);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting TransferSubscriptionsCount failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getDeleteSubscriptionsCountNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "DeleteSubscriptionsCount");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public ServiceCounterDataType getDeleteSubscriptionsCount() {
        Object object = this.getDeleteSubscriptionsCountNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (ServiceCounterDataType)object;
    }

    @Override
    @Mandatory
    public void setDeleteSubscriptionsCount(ServiceCounterDataType serviceCounterDataType) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getDeleteSubscriptionsCountNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting DeleteSubscriptionsCount failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(serviceCounterDataType);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting DeleteSubscriptionsCount failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getAddNodesCountNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "AddNodesCount");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public ServiceCounterDataType getAddNodesCount() {
        Object object = this.getAddNodesCountNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (ServiceCounterDataType)object;
    }

    @Override
    @Mandatory
    public void setAddNodesCount(ServiceCounterDataType serviceCounterDataType) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getAddNodesCountNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting AddNodesCount failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(serviceCounterDataType);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting AddNodesCount failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getAddReferencesCountNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "AddReferencesCount");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public ServiceCounterDataType getAddReferencesCount() {
        Object object = this.getAddReferencesCountNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (ServiceCounterDataType)object;
    }

    @Override
    @Mandatory
    public void setAddReferencesCount(ServiceCounterDataType serviceCounterDataType) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getAddReferencesCountNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting AddReferencesCount failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(serviceCounterDataType);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting AddReferencesCount failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getDeleteNodesCountNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "DeleteNodesCount");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public ServiceCounterDataType getDeleteNodesCount() {
        Object object = this.getDeleteNodesCountNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (ServiceCounterDataType)object;
    }

    @Override
    @Mandatory
    public void setDeleteNodesCount(ServiceCounterDataType serviceCounterDataType) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getDeleteNodesCountNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting DeleteNodesCount failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(serviceCounterDataType);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting DeleteNodesCount failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getDeleteReferencesCountNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "DeleteReferencesCount");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public ServiceCounterDataType getDeleteReferencesCount() {
        Object object = this.getDeleteReferencesCountNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (ServiceCounterDataType)object;
    }

    @Override
    @Mandatory
    public void setDeleteReferencesCount(ServiceCounterDataType serviceCounterDataType) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getDeleteReferencesCountNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting DeleteReferencesCount failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(serviceCounterDataType);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting DeleteReferencesCount failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getBrowseCountNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "BrowseCount");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public ServiceCounterDataType getBrowseCount() {
        Object object = this.getBrowseCountNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (ServiceCounterDataType)object;
    }

    @Override
    @Mandatory
    public void setBrowseCount(ServiceCounterDataType serviceCounterDataType) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getBrowseCountNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting BrowseCount failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(serviceCounterDataType);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting BrowseCount failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getBrowseNextCountNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "BrowseNextCount");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public ServiceCounterDataType getBrowseNextCount() {
        Object object = this.getBrowseNextCountNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (ServiceCounterDataType)object;
    }

    @Override
    @Mandatory
    public void setBrowseNextCount(ServiceCounterDataType serviceCounterDataType) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getBrowseNextCountNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting BrowseNextCount failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(serviceCounterDataType);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting BrowseNextCount failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getTranslateBrowsePathsToNodeIdsCountNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "TranslateBrowsePathsToNodeIdsCount");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public ServiceCounterDataType getTranslateBrowsePathsToNodeIdsCount() {
        Object object = this.getTranslateBrowsePathsToNodeIdsCountNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (ServiceCounterDataType)object;
    }

    @Override
    @Mandatory
    public void setTranslateBrowsePathsToNodeIdsCount(ServiceCounterDataType serviceCounterDataType) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getTranslateBrowsePathsToNodeIdsCountNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting TranslateBrowsePathsToNodeIdsCount failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(serviceCounterDataType);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting TranslateBrowsePathsToNodeIdsCount failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getQueryFirstCountNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "QueryFirstCount");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public ServiceCounterDataType getQueryFirstCount() {
        Object object = this.getQueryFirstCountNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (ServiceCounterDataType)object;
    }

    @Override
    @Mandatory
    public void setQueryFirstCount(ServiceCounterDataType serviceCounterDataType) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getQueryFirstCountNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting QueryFirstCount failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(serviceCounterDataType);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting QueryFirstCount failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getQueryNextCountNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "QueryNextCount");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public ServiceCounterDataType getQueryNextCount() {
        Object object = this.getQueryNextCountNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (ServiceCounterDataType)object;
    }

    @Override
    @Mandatory
    public void setQueryNextCount(ServiceCounterDataType serviceCounterDataType) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getQueryNextCountNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting QueryNextCount failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(serviceCounterDataType);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting QueryNextCount failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getRegisterNodesCountNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "RegisterNodesCount");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public ServiceCounterDataType getRegisterNodesCount() {
        Object object = this.getRegisterNodesCountNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (ServiceCounterDataType)object;
    }

    @Override
    @Mandatory
    public void setRegisterNodesCount(ServiceCounterDataType serviceCounterDataType) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getRegisterNodesCountNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting RegisterNodesCount failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(serviceCounterDataType);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting RegisterNodesCount failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getUnregisterNodesCountNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "UnregisterNodesCount");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public ServiceCounterDataType getUnregisterNodesCount() {
        Object object = this.getUnregisterNodesCountNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (ServiceCounterDataType)object;
    }

    @Override
    @Mandatory
    public void setUnregisterNodesCount(ServiceCounterDataType serviceCounterDataType) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getUnregisterNodesCountNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting UnregisterNodesCount failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(serviceCounterDataType);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting UnregisterNodesCount failed unexpectedly", statusException);
        }
    }
}

