/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.server.NodeManagerUaNode;
import com.prosysopc.ua.types.opcua.server.SessionDiagnosticsVariableTypeNodeBase;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import org.opcfoundation.ua.builtintypes.LocalizedText;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.QualifiedName;
import org.opcfoundation.ua.builtintypes.UnsignedInteger;
import org.opcfoundation.ua.core.ServiceCounterDataType;
import org.opcfoundation.ua.core.SessionDiagnosticsDataType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=2197")
public class SessionDiagnosticsVariableTypeNode
extends SessionDiagnosticsVariableTypeNodeBase {
    private static final Logger logger = LoggerFactory.getLogger(SessionDiagnosticsVariableTypeNode.class);

    protected SessionDiagnosticsVariableTypeNode(NodeManagerUaNode nodeManagerUaNode, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        super(nodeManagerUaNode, nodeId, qualifiedName, localizedText);
    }

    @Override
    public void afterCreate() {
        Object object;
        Object object2;
        super.afterCreate();
        SessionDiagnosticsDataType sessionDiagnosticsDataType = new SessionDiagnosticsDataType();
        sessionDiagnosticsDataType.setCurrentMonitoredItemsCount(UnsignedInteger.ZERO);
        sessionDiagnosticsDataType.setCurrentSubscriptionsCount(UnsignedInteger.ZERO);
        sessionDiagnosticsDataType.setCurrentPublishRequestsInQueue(UnsignedInteger.ZERO);
        for (Method method : sessionDiagnosticsDataType.getClass().getMethods()) {
            object2 = method.getGenericParameterTypes();
            if (((Type[])object2).length <= 0 || !object2[0].equals(ServiceCounterDataType.class)) continue;
            try {
                object = new ServiceCounterDataType();
                object.setTotalCount(UnsignedInteger.ZERO);
                object.setErrorCount(UnsignedInteger.ZERO);
                method.invoke((Object)sessionDiagnosticsDataType, object);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new RuntimeException(illegalArgumentException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new RuntimeException(illegalAccessException);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new RuntimeException(invocationTargetException);
            }
        }
        for (Method method : sessionDiagnosticsDataType.getClass().getMethods()) {
            try {
                object2 = method.getName();
                if (!((String)object2).startsWith("get") || (object = method.invoke((Object)sessionDiagnosticsDataType, new Object[0])) == null) continue;
                object2 = ((String)object2).substring(3, ((String)object2).length());
                try {
                    object2 = this.getClass().getMethod("set" + (String)object2, object.getClass());
                    ((Method)object2).invoke((Object)this, object);
                }
                catch (Exception exception) {}
            }
            catch (Exception exception) {
                logger.error("Failed to initialise field " + method, (Throwable)exception);
                throw new RuntimeException();
            }
        }
        try {
            this.setValue(sessionDiagnosticsDataType);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException(statusException);
        }
    }

    public void clear() {
        this.afterCreate();
    }

    public void decCurrentMonitoredItemsCount() {
        UnsignedInteger unsignedInteger = this.getCurrentMonitoredItemsCount();
        if (!unsignedInteger.equals((Object)UnsignedInteger.ZERO)) {
            unsignedInteger.dec();
        }
        this.setCurrentMonitoredItemsCount(this.getCurrentMonitoredItemsCount().dec());
    }

    public void decCurrentPublishRequestsInQueue() {
        UnsignedInteger unsignedInteger = this.getCurrentPublishRequestsInQueue();
        unsignedInteger = unsignedInteger.equals((Object)UnsignedInteger.ZERO) ? unsignedInteger : unsignedInteger.dec();
        this.setCurrentPublishRequestsInQueue(unsignedInteger);
    }

    public void decCurrentSubscriptionsCount() {
        UnsignedInteger unsignedInteger = this.getCurrentSubscriptionsCount();
        unsignedInteger = unsignedInteger.equals((Object)UnsignedInteger.ZERO) ? unsignedInteger : unsignedInteger.dec();
        this.setCurrentSubscriptionsCount(unsignedInteger);
    }

    public void incCurrentMonitoredItemsCount() {
        this.setCurrentMonitoredItemsCount(this.getCurrentMonitoredItemsCount().inc());
    }

    public void incCurrentPublishRequestsInQueue() {
        this.setCurrentPublishRequestsInQueue(this.getCurrentPublishRequestsInQueue().inc());
    }

    public void incCurrentSubscriptionsCount() {
        this.setCurrentSubscriptionsCount(this.getCurrentSubscriptionsCount().inc());
    }

    public void setCurrentMonitoredItemsCount(int n2) {
        this.setCurrentMonitoredItemsCount(UnsignedInteger.valueOf((long)n2));
    }

    public void setCurrentSubscriptionsCount(int n2) {
        this.setCurrentSubscriptionsCount(UnsignedInteger.valueOf((long)n2));
    }
}

