/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.server.NodeManagerUaNode;
import com.prosysopc.ua.types.opcua.SessionDiagnosticsObjectType;
import com.prosysopc.ua.types.opcua.server.BaseObjectTypeNode;
import com.prosysopc.ua.types.opcua.server.SessionDiagnosticsVariableTypeNode;
import com.prosysopc.ua.types.opcua.server.SessionSecurityDiagnosticsTypeNode;
import com.prosysopc.ua.types.opcua.server.SubscriptionDiagnosticsArrayTypeNode;
import org.opcfoundation.ua.builtintypes.LocalizedText;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.QualifiedName;
import org.opcfoundation.ua.core.SessionDiagnosticsDataType;
import org.opcfoundation.ua.core.SessionSecurityDiagnosticsDataType;
import org.opcfoundation.ua.core.SubscriptionDiagnosticsDataType;

public abstract class SessionDiagnosticsObjectTypeNodeBase
extends BaseObjectTypeNode
implements SessionDiagnosticsObjectType {
    protected SessionDiagnosticsObjectTypeNodeBase(NodeManagerUaNode nodeManagerUaNode, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        super(nodeManagerUaNode, nodeId, qualifiedName, localizedText);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
        this.callAfterCreateIfExists(this.getSessionDiagnosticsNode());
        this.callAfterCreateIfExists(this.getSessionSecurityDiagnosticsNode());
        this.callAfterCreateIfExists(this.getSubscriptionDiagnosticsArrayNode());
    }

    @Override
    @Mandatory
    public SessionDiagnosticsVariableTypeNode getSessionDiagnosticsNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "SessionDiagnostics");
        return (SessionDiagnosticsVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public SessionDiagnosticsDataType getSessionDiagnostics() {
        Object object = this.getSessionDiagnosticsNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (SessionDiagnosticsDataType)object;
    }

    @Override
    @Mandatory
    public void setSessionDiagnostics(SessionDiagnosticsDataType sessionDiagnosticsDataType) {
        SessionDiagnosticsVariableTypeNode sessionDiagnosticsVariableTypeNode = this.getSessionDiagnosticsNode();
        if (sessionDiagnosticsVariableTypeNode == null) {
            throw new RuntimeException("Setting SessionDiagnostics failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            sessionDiagnosticsVariableTypeNode.setValue(sessionDiagnosticsDataType);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting SessionDiagnostics failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public SessionSecurityDiagnosticsTypeNode getSessionSecurityDiagnosticsNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "SessionSecurityDiagnostics");
        return (SessionSecurityDiagnosticsTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public SessionSecurityDiagnosticsDataType getSessionSecurityDiagnostics() {
        Object object = this.getSessionSecurityDiagnosticsNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (SessionSecurityDiagnosticsDataType)object;
    }

    @Override
    @Mandatory
    public void setSessionSecurityDiagnostics(SessionSecurityDiagnosticsDataType sessionSecurityDiagnosticsDataType) {
        SessionSecurityDiagnosticsTypeNode sessionSecurityDiagnosticsTypeNode = this.getSessionSecurityDiagnosticsNode();
        if (sessionSecurityDiagnosticsTypeNode == null) {
            throw new RuntimeException("Setting SessionSecurityDiagnostics failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            sessionSecurityDiagnosticsTypeNode.setValue(sessionSecurityDiagnosticsDataType);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting SessionSecurityDiagnostics failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public SubscriptionDiagnosticsArrayTypeNode getSubscriptionDiagnosticsArrayNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "SubscriptionDiagnosticsArray");
        return (SubscriptionDiagnosticsArrayTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public SubscriptionDiagnosticsDataType[] getSubscriptionDiagnosticsArray() {
        Object object = this.getSubscriptionDiagnosticsArrayNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (SubscriptionDiagnosticsDataType[])object;
    }

    @Override
    @Mandatory
    public void setSubscriptionDiagnosticsArray(SubscriptionDiagnosticsDataType[] subscriptionDiagnosticsDataTypeArray) {
        SubscriptionDiagnosticsArrayTypeNode subscriptionDiagnosticsArrayTypeNode = this.getSubscriptionDiagnosticsArrayNode();
        if (subscriptionDiagnosticsArrayTypeNode == null) {
            throw new RuntimeException("Setting SubscriptionDiagnosticsArray failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            subscriptionDiagnosticsArrayTypeNode.setValue(subscriptionDiagnosticsDataTypeArray);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting SubscriptionDiagnosticsArray failed unexpectedly", statusException);
        }
    }
}

