/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.Optional;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.server.NodeManagerUaNode;
import com.prosysopc.ua.server.ServiceContext;
import com.prosysopc.ua.types.opcua.ServerType;
import com.prosysopc.ua.types.opcua.server.BaseObjectTypeNode;
import com.prosysopc.ua.types.opcua.server.NamespacesTypeNode;
import com.prosysopc.ua.types.opcua.server.ServerCapabilitiesTypeNode;
import com.prosysopc.ua.types.opcua.server.ServerDiagnosticsTypeNode;
import com.prosysopc.ua.types.opcua.server.ServerRedundancyTypeNode;
import com.prosysopc.ua.types.opcua.server.ServerStatusTypeNode;
import com.prosysopc.ua.types.opcua.server.VendorServerInfoTypeNode;
import org.opcfoundation.ua.builtintypes.DiagnosticInfo;
import org.opcfoundation.ua.builtintypes.LocalizedText;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.QualifiedName;
import org.opcfoundation.ua.builtintypes.StatusCode;
import org.opcfoundation.ua.builtintypes.UnsignedByte;
import org.opcfoundation.ua.builtintypes.UnsignedInteger;
import org.opcfoundation.ua.builtintypes.Variant;
import org.opcfoundation.ua.core.ServerStatusDataType;

public abstract class ServerTypeNodeBase
extends BaseObjectTypeNode
implements ServerType {
    protected ServerTypeNodeBase(NodeManagerUaNode nodeManagerUaNode, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        super(nodeManagerUaNode, nodeId, qualifiedName, localizedText);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
        this.callAfterCreateIfExists(this.getServerStatusNode());
        this.callAfterCreateIfExists(this.getServerCapabilitiesNode());
        this.callAfterCreateIfExists(this.getServerDiagnosticsNode());
        this.callAfterCreateIfExists(this.getVendorServerInfoNode());
        this.callAfterCreateIfExists(this.getServerRedundancyNode());
        this.callAfterCreateIfExists(this.getNamespacesNode());
    }

    @Override
    @Mandatory
    public UaProperty getServerArrayNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ServerArray");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public String[] getServerArray() {
        Object object = this.getServerArrayNode();
        if (object == null) {
            throw new RuntimeException("Mandatory node ServerArray does not exist");
        }
        object = object.getValue().getValue().getValue();
        return (String[])object;
    }

    @Override
    @Mandatory
    public void setServerArray(String[] stringArray) {
        UaProperty uaProperty = this.getServerArrayNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting ServerArray failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(stringArray);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting ServerArray failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public UaProperty getNamespaceArrayNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "NamespaceArray");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public String[] getNamespaceArray() {
        Object object = this.getNamespaceArrayNode();
        if (object == null) {
            throw new RuntimeException("Mandatory node NamespaceArray does not exist");
        }
        object = object.getValue().getValue().getValue();
        return (String[])object;
    }

    @Override
    @Mandatory
    public void setNamespaceArray(String[] stringArray) {
        UaProperty uaProperty = this.getNamespaceArrayNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting NamespaceArray failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(stringArray);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting NamespaceArray failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public UaProperty getServiceLevelNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ServiceLevel");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public UnsignedByte getServiceLevel() {
        Object object = this.getServiceLevelNode();
        if (object == null) {
            throw new RuntimeException("Mandatory node ServiceLevel does not exist");
        }
        object = object.getValue().getValue().getValue();
        return (UnsignedByte)object;
    }

    @Override
    @Mandatory
    public void setServiceLevel(UnsignedByte unsignedByte) {
        UaProperty uaProperty = this.getServiceLevelNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting ServiceLevel failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(unsignedByte);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting ServiceLevel failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public UaProperty getAuditingNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Auditing");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public Boolean isAuditing() {
        Object object = this.getAuditingNode();
        if (object == null) {
            throw new RuntimeException("Mandatory node Auditing does not exist");
        }
        object = object.getValue().getValue().getValue();
        return (Boolean)object;
    }

    @Override
    @Mandatory
    public void setAuditing(Boolean bl) {
        UaProperty uaProperty = this.getAuditingNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting Auditing failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(bl);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting Auditing failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public ServerStatusTypeNode getServerStatusNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ServerStatus");
        return (ServerStatusTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public ServerStatusDataType getServerStatus() {
        Object object = this.getServerStatusNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (ServerStatusDataType)object;
    }

    @Override
    @Mandatory
    public void setServerStatus(ServerStatusDataType serverStatusDataType) {
        ServerStatusTypeNode serverStatusTypeNode = this.getServerStatusNode();
        if (serverStatusTypeNode == null) {
            throw new RuntimeException("Setting ServerStatus failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            serverStatusTypeNode.setValue(serverStatusDataType);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting ServerStatus failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public ServerCapabilitiesTypeNode getServerCapabilitiesNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ServerCapabilities");
        return (ServerCapabilitiesTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public ServerDiagnosticsTypeNode getServerDiagnosticsNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ServerDiagnostics");
        return (ServerDiagnosticsTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public VendorServerInfoTypeNode getVendorServerInfoNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "VendorServerInfo");
        return (VendorServerInfoTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public ServerRedundancyTypeNode getServerRedundancyNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ServerRedundancy");
        return (ServerRedundancyTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Optional
    public NamespacesTypeNode getNamespacesNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Namespaces");
        return (NamespacesTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    public Variant[] callMethod(ServiceContext unsignedIntegerArray, NodeId nodeId, Variant[] variantArray, StatusCode[] statusCodeArray, DiagnosticInfo[] diagnosticInfoArray) throws StatusException {
        Object object = this.getQualifiedName("http://opcfoundation.org/UA/", "GetMonitoredItems");
        if ((object = this.getComponent((QualifiedName)object)) != null && object.getNodeId().equals((Object)nodeId)) {
            unsignedIntegerArray = this.onGetMonitoredItems((ServiceContext)unsignedIntegerArray, (UnsignedInteger)variantArray[0].getValue());
            return new Variant[]{new Variant((Object)unsignedIntegerArray[0]), new Variant((Object)unsignedIntegerArray[1])};
        }
        return super.callMethod((ServiceContext)unsignedIntegerArray, nodeId, variantArray, statusCodeArray, diagnosticInfoArray);
    }

    @Override
    public UnsignedInteger[][] getMonitoredItems(UnsignedInteger unsignedInteger) throws StatusException {
        return this.onGetMonitoredItems(ServiceContext.INTERNAL_OPERATION_CONTEXT, unsignedInteger);
    }

    protected abstract UnsignedInteger[][] onGetMonitoredItems(ServiceContext var1, UnsignedInteger var2) throws StatusException;
}

