/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.MonitoredItemBase;
import com.prosysopc.ua.ServiceException;
import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.SubscriptionBase;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.server.NodeManagerUaNode;
import com.prosysopc.ua.server.ServiceContext;
import com.prosysopc.ua.server.Subscription;
import com.prosysopc.ua.types.opcua.server.ServerTypeNodeBase;
import org.opcfoundation.ua.builtintypes.LocalizedText;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.QualifiedName;
import org.opcfoundation.ua.builtintypes.UnsignedByte;
import org.opcfoundation.ua.builtintypes.UnsignedInteger;
import org.opcfoundation.ua.core.AccessLevel;
import org.opcfoundation.ua.core.ServerState;
import org.opcfoundation.ua.core.StatusCodes;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=2004")
public class ServerTypeNode
extends ServerTypeNodeBase {
    protected ServerTypeNode(NodeManagerUaNode nodeManagerUaNode, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        super(nodeManagerUaNode, nodeId, qualifiedName, localizedText);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
        this.getServerCapabilitiesNode().afterCreate();
        this.getServerDiagnosticsNode().afterCreate();
        this.getServerStatusNode().afterCreate();
        this.getServerRedundancyNode().afterCreate();
        this.setServiceLevel(255);
        this.getServiceLevelNode().setAccessLevel(AccessLevel.READONLY);
        this.setAuditing(Boolean.FALSE);
        ServerTypeNode.setAccessLevelRecursively(this.getServerStatusNode(), AccessLevel.READONLY, new NodeId[0]);
        ServerTypeNode.setAccessLevelRecursively(this.getAuditingNode(), AccessLevel.READONLY, new NodeId[0]);
    }

    public void setServiceLevel(int n2) {
        this.setServiceLevel(UnsignedByte.valueOf((int)n2));
    }

    @Override
    public void setServiceLevel(UnsignedByte unsignedByte) {
        super.setServiceLevel(unsignedByte);
    }

    public void shutdown(long l2, LocalizedText localizedText) {
        this.getServerStatusNode().setState(ServerState.Shutdown);
        this.getServerStatusNode().b(l2, localizedText);
    }

    public void start() {
        this.updateNamespaceArray();
        this.getServerStatusNode().b(0L, null);
        this.getServerStatusNode().setState(ServerState.Running);
    }

    public void updateNamespaceArray() {
        try {
            this.getNamespaceArrayNode().setValue(this.nodeManager.getNamespaceTable().toArray());
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException(statusException);
        }
    }

    public void updateServerArray() {
        try {
            this.getServerArrayNode().setValue(this.nodeManager.getNodeManagerTable().getServerTable().toArray());
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException(statusException);
        }
    }

    @Override
    protected UnsignedInteger[][] onGetMonitoredItems(ServiceContext unsignedIntegerArray, UnsignedInteger object) throws StatusException {
        try {
            object = this.getNodeManager().getNodeManagerTable().getServer().getSubscriptionManager().getSubscription((UnsignedInteger)object);
            if (((Subscription)object).getSession() == null || ((Subscription)object).getSession() != unsignedIntegerArray.getSession()) {
                throw new StatusException(StatusCodes.Bad_UserAccessDenied);
            }
            MonitoredItemBase[] monitoredItemBaseArray = ((SubscriptionBase)object).getItems();
            unsignedIntegerArray = new UnsignedInteger[monitoredItemBaseArray.length];
            object = new UnsignedInteger[monitoredItemBaseArray.length];
            for (int i2 = 0; i2 < monitoredItemBaseArray.length; ++i2) {
                unsignedIntegerArray[i2] = monitoredItemBaseArray[i2].getMonitoredItemId();
                object[i2] = monitoredItemBaseArray[i2].getClientHandle();
            }
        }
        catch (ServiceException serviceException) {
            throw new StatusException(serviceException.getServiceResult());
        }
        return new UnsignedInteger[][]{unsignedIntegerArray, object};
    }
}

