/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.server.NodeManagerUaNode;
import com.prosysopc.ua.types.opcua.ServerStatusType;
import com.prosysopc.ua.types.opcua.server.BaseDataVariableTypeNode;
import com.prosysopc.ua.types.opcua.server.BuildInfoTypeNode;
import org.opcfoundation.ua.builtintypes.DateTime;
import org.opcfoundation.ua.builtintypes.LocalizedText;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.QualifiedName;
import org.opcfoundation.ua.builtintypes.UnsignedInteger;
import org.opcfoundation.ua.core.BuildInfo;
import org.opcfoundation.ua.core.ServerState;

public abstract class ServerStatusTypeNodeBase
extends BaseDataVariableTypeNode
implements ServerStatusType {
    protected ServerStatusTypeNodeBase(NodeManagerUaNode nodeManagerUaNode, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        super(nodeManagerUaNode, nodeId, qualifiedName, localizedText);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
        this.callAfterCreateIfExists(this.getStartTimeNode());
        this.callAfterCreateIfExists(this.getCurrentTimeNode());
        this.callAfterCreateIfExists(this.getStateNode());
        this.callAfterCreateIfExists(this.getBuildInfoNode());
        this.callAfterCreateIfExists(this.getSecondsTillShutdownNode());
        this.callAfterCreateIfExists(this.getShutdownReasonNode());
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getStartTimeNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "StartTime");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public DateTime getStartTime() {
        Object object = this.getStartTimeNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (DateTime)object;
    }

    @Override
    @Mandatory
    public void setStartTime(DateTime dateTime) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getStartTimeNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting StartTime failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(dateTime);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting StartTime failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getCurrentTimeNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "CurrentTime");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public DateTime getCurrentTime() {
        Object object = this.getCurrentTimeNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (DateTime)object;
    }

    @Override
    @Mandatory
    public void setCurrentTime(DateTime dateTime) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getCurrentTimeNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting CurrentTime failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(dateTime);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting CurrentTime failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getStateNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "State");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public ServerState getState() {
        Object object = this.getStateNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return ServerState.valueOf((Integer)((Integer)object));
    }

    @Override
    @Mandatory
    public void setState(ServerState serverState) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getStateNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting State failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(serverState);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting State failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public BuildInfoTypeNode getBuildInfoNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "BuildInfo");
        return (BuildInfoTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public BuildInfo getBuildInfo() {
        Object object = this.getBuildInfoNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (BuildInfo)object;
    }

    @Override
    @Mandatory
    public void setBuildInfo(BuildInfo buildInfo) {
        BuildInfoTypeNode buildInfoTypeNode = this.getBuildInfoNode();
        if (buildInfoTypeNode == null) {
            throw new RuntimeException("Setting BuildInfo failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            buildInfoTypeNode.setValue(buildInfo);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting BuildInfo failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getSecondsTillShutdownNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "SecondsTillShutdown");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public UnsignedInteger getSecondsTillShutdown() {
        Object object = this.getSecondsTillShutdownNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (UnsignedInteger)object;
    }

    @Override
    @Mandatory
    public void setSecondsTillShutdown(UnsignedInteger unsignedInteger) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getSecondsTillShutdownNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting SecondsTillShutdown failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(unsignedInteger);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting SecondsTillShutdown failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getShutdownReasonNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ShutdownReason");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public LocalizedText getShutdownReason() {
        Object object = this.getShutdownReasonNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (LocalizedText)object;
    }

    @Override
    @Mandatory
    public void setShutdownReason(LocalizedText localizedText) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getShutdownReasonNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting ShutdownReason failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(localizedText);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting ShutdownReason failed unexpectedly", statusException);
        }
    }
}

