/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.WriteAccess;
import com.prosysopc.ua.server.NodeManagerUaNode;
import com.prosysopc.ua.server.ServiceContext;
import com.prosysopc.ua.server.io.UaNodeIoListener;
import com.prosysopc.ua.server.io.UaVariableIoListener;
import com.prosysopc.ua.types.opcua.server.ServerStatusTypeNodeBase;
import java.util.EnumSet;
import org.opcfoundation.ua.builtintypes.DataValue;
import org.opcfoundation.ua.builtintypes.DateTime;
import org.opcfoundation.ua.builtintypes.LocalizedText;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.QualifiedName;
import org.opcfoundation.ua.builtintypes.StatusCode;
import org.opcfoundation.ua.builtintypes.UnsignedInteger;
import org.opcfoundation.ua.builtintypes.Variant;
import org.opcfoundation.ua.core.AccessLevel;
import org.opcfoundation.ua.core.ServerStatusDataType;
import org.opcfoundation.ua.core.TimestampsToReturn;
import org.opcfoundation.ua.utils.NumericRange;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=2138")
public class ServerStatusTypeNode
extends ServerStatusTypeNodeBase {
    protected ServerStatusTypeNode(NodeManagerUaNode nodeManagerUaNode, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        super(nodeManagerUaNode, nodeId, qualifiedName, localizedText);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
        this.setStartTime(DateTime.currentTime());
        this.getNodeManager().getIoManager().addNodeListener(this.getCurrentTimeNode(), (UaNodeIoListener)new UaVariableIoListener(this){

            @Override
            public final EnumSet<AccessLevel> onGetUserAccessLevel(ServiceContext serviceContext) {
                return null;
            }

            @Override
            public final EnumSet<WriteAccess> onGetUserWriteMask(ServiceContext serviceContext) {
                return null;
            }

            @Override
            public final boolean onReadNonValue(ServiceContext serviceContext, UnsignedInteger unsignedInteger, DataValue dataValue) throws StatusException {
                return false;
            }

            @Override
            public final boolean onReadValue(ServiceContext serviceContext, NumericRange numericRange, TimestampsToReturn timestampsToReturn, DateTime dateTime, DataValue dataValue) throws StatusException {
                serviceContext = dataValue.getServerTimestamp();
                dataValue.setStatusCode(StatusCode.GOOD);
                dataValue.setSourceTimestamp((DateTime)serviceContext);
                dataValue.setServerTimestamp((DateTime)serviceContext);
                dataValue.setValue(new Variant((Object)serviceContext));
                return true;
            }

            @Override
            public final boolean onWriteNonValue(ServiceContext serviceContext, UnsignedInteger unsignedInteger, DataValue dataValue) throws StatusException {
                return false;
            }

            @Override
            public final boolean onWriteValue(ServiceContext serviceContext, NumericRange numericRange, DataValue dataValue) throws StatusException {
                return false;
            }
        });
        this.getNodeManager().getIoManager().addNodeListener(this, (UaNodeIoListener)new UaVariableIoListener(this){

            @Override
            public final EnumSet<AccessLevel> onGetUserAccessLevel(ServiceContext serviceContext) {
                return null;
            }

            @Override
            public final EnumSet<WriteAccess> onGetUserWriteMask(ServiceContext serviceContext) {
                return null;
            }

            @Override
            public final boolean onReadNonValue(ServiceContext serviceContext, UnsignedInteger unsignedInteger, DataValue dataValue) throws StatusException {
                return false;
            }

            @Override
            public final boolean onReadValue(ServiceContext serviceContext, NumericRange numericRange, TimestampsToReturn timestampsToReturn, DateTime dateTime, DataValue dataValue) throws StatusException {
                serviceContext = (ServerStatusDataType)dataValue.getValue().getValue();
                numericRange = dataValue.getServerTimestamp();
                serviceContext.setCurrentTime((DateTime)numericRange);
                dataValue.setSourceTimestamp((DateTime)numericRange);
                return false;
            }

            @Override
            public final boolean onWriteNonValue(ServiceContext serviceContext, UnsignedInteger unsignedInteger, DataValue dataValue) throws StatusException {
                return false;
            }

            @Override
            public final boolean onWriteValue(ServiceContext serviceContext, NumericRange numericRange, DataValue dataValue) throws StatusException {
                return false;
            }
        });
    }

    final void b(long l2, LocalizedText localizedText) {
        this.setShutdownReason(localizedText);
        this.setSecondsTillShutdown(UnsignedInteger.valueOf((long)l2));
    }
}

