/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.Optional;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.server.NodeManagerUaNode;
import com.prosysopc.ua.types.opcua.ServerDiagnosticsType;
import com.prosysopc.ua.types.opcua.server.BaseObjectTypeNode;
import com.prosysopc.ua.types.opcua.server.SamplingIntervalDiagnosticsArrayTypeNode;
import com.prosysopc.ua.types.opcua.server.ServerDiagnosticsSummaryTypeNode;
import com.prosysopc.ua.types.opcua.server.SessionsDiagnosticsSummaryTypeNode;
import com.prosysopc.ua.types.opcua.server.SubscriptionDiagnosticsArrayTypeNode;
import org.opcfoundation.ua.builtintypes.LocalizedText;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.QualifiedName;
import org.opcfoundation.ua.core.SamplingIntervalDiagnosticsDataType;
import org.opcfoundation.ua.core.ServerDiagnosticsSummaryDataType;
import org.opcfoundation.ua.core.SubscriptionDiagnosticsDataType;

public abstract class ServerDiagnosticsTypeNodeBase
extends BaseObjectTypeNode
implements ServerDiagnosticsType {
    protected ServerDiagnosticsTypeNodeBase(NodeManagerUaNode nodeManagerUaNode, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        super(nodeManagerUaNode, nodeId, qualifiedName, localizedText);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
        this.callAfterCreateIfExists(this.getServerDiagnosticsSummaryNode());
        this.callAfterCreateIfExists(this.getSamplingIntervalDiagnosticsArrayNode());
        this.callAfterCreateIfExists(this.getSubscriptionDiagnosticsArrayNode());
        this.callAfterCreateIfExists(this.getSessionsDiagnosticsSummaryNode());
    }

    @Override
    @Mandatory
    public UaProperty getEnabledFlagNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "EnabledFlag");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public Boolean isEnabledFlag() {
        Object object = this.getEnabledFlagNode();
        if (object == null) {
            throw new RuntimeException("Mandatory node EnabledFlag does not exist");
        }
        object = object.getValue().getValue().getValue();
        return (Boolean)object;
    }

    @Override
    @Mandatory
    public void setEnabledFlag(Boolean bl) {
        UaProperty uaProperty = this.getEnabledFlagNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting EnabledFlag failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(bl);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting EnabledFlag failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public ServerDiagnosticsSummaryTypeNode getServerDiagnosticsSummaryNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ServerDiagnosticsSummary");
        return (ServerDiagnosticsSummaryTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public ServerDiagnosticsSummaryDataType getServerDiagnosticsSummary() {
        Object object = this.getServerDiagnosticsSummaryNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (ServerDiagnosticsSummaryDataType)object;
    }

    @Override
    @Mandatory
    public void setServerDiagnosticsSummary(ServerDiagnosticsSummaryDataType serverDiagnosticsSummaryDataType) {
        ServerDiagnosticsSummaryTypeNode serverDiagnosticsSummaryTypeNode = this.getServerDiagnosticsSummaryNode();
        if (serverDiagnosticsSummaryTypeNode == null) {
            throw new RuntimeException("Setting ServerDiagnosticsSummary failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            serverDiagnosticsSummaryTypeNode.setValue(serverDiagnosticsSummaryDataType);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting ServerDiagnosticsSummary failed unexpectedly", statusException);
        }
    }

    @Override
    @Optional
    public SamplingIntervalDiagnosticsArrayTypeNode getSamplingIntervalDiagnosticsArrayNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "SamplingIntervalDiagnosticsArray");
        return (SamplingIntervalDiagnosticsArrayTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Optional
    public SamplingIntervalDiagnosticsDataType[] getSamplingIntervalDiagnosticsArray() {
        Object object = this.getSamplingIntervalDiagnosticsArrayNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (SamplingIntervalDiagnosticsDataType[])object;
    }

    @Override
    @Optional
    public void setSamplingIntervalDiagnosticsArray(SamplingIntervalDiagnosticsDataType[] samplingIntervalDiagnosticsDataTypeArray) {
        SamplingIntervalDiagnosticsArrayTypeNode samplingIntervalDiagnosticsArrayTypeNode = this.getSamplingIntervalDiagnosticsArrayNode();
        if (samplingIntervalDiagnosticsArrayTypeNode == null) {
            throw new RuntimeException("Setting SamplingIntervalDiagnosticsArray failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            samplingIntervalDiagnosticsArrayTypeNode.setValue(samplingIntervalDiagnosticsDataTypeArray);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting SamplingIntervalDiagnosticsArray failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public SubscriptionDiagnosticsArrayTypeNode getSubscriptionDiagnosticsArrayNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "SubscriptionDiagnosticsArray");
        return (SubscriptionDiagnosticsArrayTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public SubscriptionDiagnosticsDataType[] getSubscriptionDiagnosticsArray() {
        Object object = this.getSubscriptionDiagnosticsArrayNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (SubscriptionDiagnosticsDataType[])object;
    }

    @Override
    @Mandatory
    public void setSubscriptionDiagnosticsArray(SubscriptionDiagnosticsDataType[] subscriptionDiagnosticsDataTypeArray) {
        SubscriptionDiagnosticsArrayTypeNode subscriptionDiagnosticsArrayTypeNode = this.getSubscriptionDiagnosticsArrayNode();
        if (subscriptionDiagnosticsArrayTypeNode == null) {
            throw new RuntimeException("Setting SubscriptionDiagnosticsArray failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            subscriptionDiagnosticsArrayTypeNode.setValue(subscriptionDiagnosticsDataTypeArray);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting SubscriptionDiagnosticsArray failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public SessionsDiagnosticsSummaryTypeNode getSessionsDiagnosticsSummaryNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "SessionsDiagnosticsSummary");
        return (SessionsDiagnosticsSummaryTypeNode)this.getComponent(qualifiedName);
    }
}

