/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.server.NodeManagerUaNode;
import com.prosysopc.ua.server.ServiceContext;
import com.prosysopc.ua.types.opcua.ServerConfigurationType;
import com.prosysopc.ua.types.opcua.server.BaseObjectTypeNode;
import com.prosysopc.ua.types.opcua.server.TrustListTypeNode;
import org.opcfoundation.ua.builtintypes.DiagnosticInfo;
import org.opcfoundation.ua.builtintypes.LocalizedText;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.QualifiedName;
import org.opcfoundation.ua.builtintypes.StatusCode;
import org.opcfoundation.ua.builtintypes.UnsignedInteger;
import org.opcfoundation.ua.builtintypes.Variant;

public abstract class ServerConfigurationTypeNodeBase
extends BaseObjectTypeNode
implements ServerConfigurationType {
    protected ServerConfigurationTypeNodeBase(NodeManagerUaNode nodeManagerUaNode, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        super(nodeManagerUaNode, nodeId, qualifiedName, localizedText);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
        this.callAfterCreateIfExists(this.getTrustListNode());
    }

    @Override
    @Mandatory
    public UaProperty getServerCapabilitiesNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ServerCapabilities");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public String[] getServerCapabilities() {
        Object object = this.getServerCapabilitiesNode();
        if (object == null) {
            throw new RuntimeException("Mandatory node ServerCapabilities does not exist");
        }
        object = object.getValue().getValue().getValue();
        return (String[])object;
    }

    @Override
    @Mandatory
    public void setServerCapabilities(String[] stringArray) {
        UaProperty uaProperty = this.getServerCapabilitiesNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting ServerCapabilities failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(stringArray);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting ServerCapabilities failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public UaProperty getSupportedCertificateTypesNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "SupportedCertificateTypes");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public NodeId[] getSupportedCertificateTypes() {
        Object object = this.getSupportedCertificateTypesNode();
        if (object == null) {
            throw new RuntimeException("Mandatory node SupportedCertificateTypes does not exist");
        }
        object = object.getValue().getValue().getValue();
        return (NodeId[])object;
    }

    @Override
    @Mandatory
    public void setSupportedCertificateTypes(NodeId[] nodeIdArray) {
        UaProperty uaProperty = this.getSupportedCertificateTypesNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting SupportedCertificateTypes failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(nodeIdArray);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting SupportedCertificateTypes failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public UaProperty getSupportedPrivateKeyFormatsNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "SupportedPrivateKeyFormats");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public String[] getSupportedPrivateKeyFormats() {
        Object object = this.getSupportedPrivateKeyFormatsNode();
        if (object == null) {
            throw new RuntimeException("Mandatory node SupportedPrivateKeyFormats does not exist");
        }
        object = object.getValue().getValue().getValue();
        return (String[])object;
    }

    @Override
    @Mandatory
    public void setSupportedPrivateKeyFormats(String[] stringArray) {
        UaProperty uaProperty = this.getSupportedPrivateKeyFormatsNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting SupportedPrivateKeyFormats failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(stringArray);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting SupportedPrivateKeyFormats failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public UaProperty getMaxTrustListSizeNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "MaxTrustListSize");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public UnsignedInteger getMaxTrustListSize() {
        Object object = this.getMaxTrustListSizeNode();
        if (object == null) {
            throw new RuntimeException("Mandatory node MaxTrustListSize does not exist");
        }
        object = object.getValue().getValue().getValue();
        return (UnsignedInteger)object;
    }

    @Override
    @Mandatory
    public void setMaxTrustListSize(UnsignedInteger unsignedInteger) {
        UaProperty uaProperty = this.getMaxTrustListSizeNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting MaxTrustListSize failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(unsignedInteger);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting MaxTrustListSize failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public UaProperty getMulticastDnsEnabledNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "MulticastDnsEnabled");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public Boolean isMulticastDnsEnabled() {
        Object object = this.getMulticastDnsEnabledNode();
        if (object == null) {
            throw new RuntimeException("Mandatory node MulticastDnsEnabled does not exist");
        }
        object = object.getValue().getValue().getValue();
        return (Boolean)object;
    }

    @Override
    @Mandatory
    public void setMulticastDnsEnabled(Boolean bl) {
        UaProperty uaProperty = this.getMulticastDnsEnabledNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting MulticastDnsEnabled failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(bl);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting MulticastDnsEnabled failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public TrustListTypeNode getTrustListNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "TrustList");
        return (TrustListTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    public Variant[] callMethod(ServiceContext object, NodeId nodeId, Variant[] variantArray, StatusCode[] statusCodeArray, DiagnosticInfo[] diagnosticInfoArray) throws StatusException {
        Object object2 = this.getQualifiedName("http://opcfoundation.org/UA/", "UpdateCertificate");
        if ((object2 = this.getComponent((QualifiedName)object2)) != null && object2.getNodeId().equals((Object)nodeId)) {
            object = this.onUpdateCertificate((ServiceContext)object, (NodeId)variantArray[0].getValue(), (byte[])variantArray[1].getValue(), (String)variantArray[2].getValue(), (byte[])variantArray[3].getValue());
            return new Variant[]{new Variant(object)};
        }
        object2 = this.getQualifiedName("http://opcfoundation.org/UA/", "Restart");
        if ((object2 = this.getComponent((QualifiedName)object2)) != null && object2.getNodeId().equals((Object)nodeId)) {
            this.onRestart((ServiceContext)object);
            return null;
        }
        return super.callMethod((ServiceContext)object, nodeId, variantArray, statusCodeArray, diagnosticInfoArray);
    }

    @Override
    public Boolean updateCertificate(NodeId nodeId, byte[] byArray, String string, byte[] byArray2) throws StatusException {
        return this.onUpdateCertificate(ServiceContext.INTERNAL_OPERATION_CONTEXT, nodeId, byArray, string, byArray2);
    }

    protected abstract Boolean onUpdateCertificate(ServiceContext var1, NodeId var2, byte[] var3, String var4, byte[] var5) throws StatusException;

    @Override
    public void restart() throws StatusException {
        this.onRestart(ServiceContext.INTERNAL_OPERATION_CONTEXT);
    }

    protected abstract void onRestart(ServiceContext var1) throws StatusException;
}

