/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.Optional;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.server.NodeManagerUaNode;
import com.prosysopc.ua.types.opcua.ServerCapabilitiesType;
import com.prosysopc.ua.types.opcua.server.BaseObjectTypeNode;
import com.prosysopc.ua.types.opcua.server.FolderTypeNode;
import com.prosysopc.ua.types.opcua.server.OperationLimitsTypeNode;
import org.opcfoundation.ua.builtintypes.LocalizedText;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.QualifiedName;
import org.opcfoundation.ua.builtintypes.UnsignedInteger;
import org.opcfoundation.ua.builtintypes.UnsignedShort;
import org.opcfoundation.ua.core.SignedSoftwareCertificate;

public abstract class ServerCapabilitiesTypeNodeBase
extends BaseObjectTypeNode
implements ServerCapabilitiesType {
    protected ServerCapabilitiesTypeNodeBase(NodeManagerUaNode nodeManagerUaNode, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        super(nodeManagerUaNode, nodeId, qualifiedName, localizedText);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
        this.callAfterCreateIfExists(this.getOperationLimitsNode());
        this.callAfterCreateIfExists(this.getModellingRulesNode());
        this.callAfterCreateIfExists(this.getAggregateFunctionsNode());
    }

    @Override
    @Mandatory
    public UaProperty getServerProfileArrayNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ServerProfileArray");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public String[] getServerProfileArray() {
        Object object = this.getServerProfileArrayNode();
        if (object == null) {
            throw new RuntimeException("Mandatory node ServerProfileArray does not exist");
        }
        object = object.getValue().getValue().getValue();
        return (String[])object;
    }

    @Override
    @Mandatory
    public void setServerProfileArray(String[] stringArray) {
        UaProperty uaProperty = this.getServerProfileArrayNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting ServerProfileArray failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(stringArray);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting ServerProfileArray failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public UaProperty getLocaleIdArrayNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "LocaleIdArray");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public String[] getLocaleIdArray() {
        Object object = this.getLocaleIdArrayNode();
        if (object == null) {
            throw new RuntimeException("Mandatory node LocaleIdArray does not exist");
        }
        object = object.getValue().getValue().getValue();
        return (String[])object;
    }

    @Override
    @Mandatory
    public void setLocaleIdArray(String[] stringArray) {
        UaProperty uaProperty = this.getLocaleIdArrayNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting LocaleIdArray failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(stringArray);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting LocaleIdArray failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public UaProperty getMinSupportedSampleRateNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "MinSupportedSampleRate");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public Double getMinSupportedSampleRate() {
        Object object = this.getMinSupportedSampleRateNode();
        if (object == null) {
            throw new RuntimeException("Mandatory node MinSupportedSampleRate does not exist");
        }
        object = object.getValue().getValue().getValue();
        return (Double)object;
    }

    @Override
    @Mandatory
    public void setMinSupportedSampleRate(Double d2) {
        UaProperty uaProperty = this.getMinSupportedSampleRateNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting MinSupportedSampleRate failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(d2);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting MinSupportedSampleRate failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public UaProperty getMaxBrowseContinuationPointsNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "MaxBrowseContinuationPoints");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public UnsignedShort getMaxBrowseContinuationPoints() {
        Object object = this.getMaxBrowseContinuationPointsNode();
        if (object == null) {
            throw new RuntimeException("Mandatory node MaxBrowseContinuationPoints does not exist");
        }
        object = object.getValue().getValue().getValue();
        return (UnsignedShort)object;
    }

    @Override
    @Mandatory
    public void setMaxBrowseContinuationPoints(UnsignedShort unsignedShort) {
        UaProperty uaProperty = this.getMaxBrowseContinuationPointsNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting MaxBrowseContinuationPoints failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(unsignedShort);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting MaxBrowseContinuationPoints failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public UaProperty getMaxQueryContinuationPointsNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "MaxQueryContinuationPoints");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public UnsignedShort getMaxQueryContinuationPoints() {
        Object object = this.getMaxQueryContinuationPointsNode();
        if (object == null) {
            throw new RuntimeException("Mandatory node MaxQueryContinuationPoints does not exist");
        }
        object = object.getValue().getValue().getValue();
        return (UnsignedShort)object;
    }

    @Override
    @Mandatory
    public void setMaxQueryContinuationPoints(UnsignedShort unsignedShort) {
        UaProperty uaProperty = this.getMaxQueryContinuationPointsNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting MaxQueryContinuationPoints failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(unsignedShort);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting MaxQueryContinuationPoints failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public UaProperty getMaxHistoryContinuationPointsNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "MaxHistoryContinuationPoints");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public UnsignedShort getMaxHistoryContinuationPoints() {
        Object object = this.getMaxHistoryContinuationPointsNode();
        if (object == null) {
            throw new RuntimeException("Mandatory node MaxHistoryContinuationPoints does not exist");
        }
        object = object.getValue().getValue().getValue();
        return (UnsignedShort)object;
    }

    @Override
    @Mandatory
    public void setMaxHistoryContinuationPoints(UnsignedShort unsignedShort) {
        UaProperty uaProperty = this.getMaxHistoryContinuationPointsNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting MaxHistoryContinuationPoints failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(unsignedShort);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting MaxHistoryContinuationPoints failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public UaProperty getSoftwareCertificatesNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "SoftwareCertificates");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public SignedSoftwareCertificate[] getSoftwareCertificates() {
        Object object = this.getSoftwareCertificatesNode();
        if (object == null) {
            throw new RuntimeException("Mandatory node SoftwareCertificates does not exist");
        }
        object = object.getValue().getValue().getValue();
        return (SignedSoftwareCertificate[])object;
    }

    @Override
    @Mandatory
    public void setSoftwareCertificates(SignedSoftwareCertificate[] signedSoftwareCertificateArray) {
        UaProperty uaProperty = this.getSoftwareCertificatesNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting SoftwareCertificates failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(signedSoftwareCertificateArray);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting SoftwareCertificates failed unexpectedly", statusException);
        }
    }

    @Override
    @Optional
    public UaProperty getMaxArrayLengthNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "MaxArrayLength");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public UnsignedInteger getMaxArrayLength() {
        Object object = this.getMaxArrayLengthNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (UnsignedInteger)object;
    }

    @Override
    @Optional
    public void setMaxArrayLength(UnsignedInteger unsignedInteger) {
        UaProperty uaProperty = this.getMaxArrayLengthNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting MaxArrayLength failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(unsignedInteger);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting MaxArrayLength failed unexpectedly", statusException);
        }
    }

    @Override
    @Optional
    public UaProperty getMaxStringLengthNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "MaxStringLength");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public UnsignedInteger getMaxStringLength() {
        Object object = this.getMaxStringLengthNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (UnsignedInteger)object;
    }

    @Override
    @Optional
    public void setMaxStringLength(UnsignedInteger unsignedInteger) {
        UaProperty uaProperty = this.getMaxStringLengthNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting MaxStringLength failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(unsignedInteger);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting MaxStringLength failed unexpectedly", statusException);
        }
    }

    @Override
    @Optional
    public OperationLimitsTypeNode getOperationLimitsNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "OperationLimits");
        return (OperationLimitsTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public FolderTypeNode getModellingRulesNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ModellingRules");
        return (FolderTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public FolderTypeNode getAggregateFunctionsNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "AggregateFunctions");
        return (FolderTypeNode)this.getComponent(qualifiedName);
    }
}

