/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaReference;
import com.prosysopc.ua.server.NodeManagerUaNode;
import com.prosysopc.ua.types.opcua.server.ServerCapabilitiesTypeNodeBase;
import org.opcfoundation.ua.builtintypes.LocalizedText;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.QualifiedName;
import org.opcfoundation.ua.builtintypes.UnsignedInteger;
import org.opcfoundation.ua.builtintypes.UnsignedShort;
import org.opcfoundation.ua.core.EndpointConfiguration;
import org.opcfoundation.ua.core.Identifiers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=2013")
public class ServerCapabilitiesTypeNode
extends ServerCapabilitiesTypeNodeBase {
    private static final Logger logger = LoggerFactory.getLogger(ServerCapabilitiesTypeNode.class);

    protected ServerCapabilitiesTypeNode(NodeManagerUaNode nodeManagerUaNode, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        super(nodeManagerUaNode, nodeId, qualifiedName, localizedText);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
        try {
            UaReference[] uaReferenceArray = this.getNodeManager().getNodeManagerTable().getType(Identifiers.ModellingRuleType);
            UaReference[] uaReferenceArray2 = uaReferenceArray.getReferences(Identifiers.HasTypeDefinition, true);
            uaReferenceArray = uaReferenceArray2;
            uaReferenceArray = uaReferenceArray2;
            int n2 = uaReferenceArray2.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Object object = uaReferenceArray[i2];
                object = ((UaReference)object).getSourceNode();
                this.getModellingRulesNode().addReference((UaNode)object, Identifiers.Organizes, false);
            }
        }
        catch (Exception exception) {
            logger.warn("Could not initialize references to ModellingRules", (Throwable)exception);
        }
        this.setServerProfileArray(new String[]{"Standard UA Server Profile", "Embedded UA Server Profile", "Micro Embedded Device Server Profile", "Nano Embedded Device Server Profile"});
        this.setLocaleIdArray(new String[]{LocalizedText.NO_LOCALE.getLanguage()});
        this.setMinSupportedSampleRate(0.0);
        this.setMaxBrowseContinuationPoints(UnsignedShort.ZERO);
        this.setMaxQueryContinuationPoints(UnsignedShort.ZERO);
        this.setMaxHistoryContinuationPoints(UnsignedShort.ZERO);
        this.getOperationLimitsNode().afterCreate();
    }

    public void setFieldsFromEndpointConfiguration(EndpointConfiguration endpointConfiguration) {
        if (endpointConfiguration.getMaxArrayLength() != null) {
            this.setMaxArrayLength(UnsignedInteger.valueOf((long)endpointConfiguration.getMaxArrayLength().intValue()));
        }
        if (endpointConfiguration.getMaxStringLength() != null) {
            this.setMaxStringLength(UnsignedInteger.valueOf((long)endpointConfiguration.getMaxStringLength().intValue()));
        }
    }
}

