/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.UaInstance;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.server.NodeManagerUaNode;
import com.prosysopc.ua.types.opcua.server.SemanticChangeEventTypeNodeBase;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.opcfoundation.ua.builtintypes.DateTime;
import org.opcfoundation.ua.builtintypes.LocalizedText;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.QualifiedName;
import org.opcfoundation.ua.common.ServiceResultException;
import org.opcfoundation.ua.core.Identifiers;
import org.opcfoundation.ua.core.SemanticChangeStructureDataType;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=2738")
public class SemanticChangeEventTypeNode
extends SemanticChangeEventTypeNodeBase {
    private final Map<NodeId, SemanticChangeStructureDataType> hg = new ConcurrentHashMap<NodeId, SemanticChangeStructureDataType>();
    private SemanticChangeStructureDataType[] hh = null;

    protected SemanticChangeEventTypeNode(NodeManagerUaNode nodeManagerUaNode, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        super(nodeManagerUaNode, nodeId, qualifiedName, localizedText);
    }

    public void addChange(NodeId nodeId, NodeId nodeId2) {
        if (!this.hg.containsKey(nodeId)) {
            this.hg.put(nodeId, new SemanticChangeStructureDataType(nodeId, nodeId2));
        }
    }

    public void addChange(UaNode uaNode) {
        NodeId nodeId = uaNode.getNodeId();
        NodeId nodeId2 = NodeId.NULL;
        if (uaNode instanceof UaInstance) {
            try {
                nodeId2 = this.getNodeManager().getNamespaceTable().toNodeId(((UaInstance)uaNode).getTypeDefinitionId());
            }
            catch (ServiceResultException serviceResultException) {
                throw new RuntimeException(serviceResultException);
            }
        }
        this.addChange(nodeId, nodeId2);
    }

    @Override
    public void afterCreate() {
        this.setSourceNode(Identifiers.Server);
    }

    public void clearChanges() {
        this.hg.clear();
        this.hh = null;
    }

    @Override
    public SemanticChangeStructureDataType[] getChanges() {
        if (this.hh != null) {
            return this.hh;
        }
        return this.hg.values().toArray(new SemanticChangeStructureDataType[this.hg.size()]);
    }

    @Override
    public NodeId getSourceNode() {
        NodeId nodeId = super.getSourceNode();
        if (nodeId == null) {
            return Identifiers.Server;
        }
        return nodeId;
    }

    @Override
    public void setChanges(SemanticChangeStructureDataType[] semanticChangeStructureDataTypeArray) {
        this.clearChanges();
        this.hh = semanticChangeStructureDataTypeArray;
    }

    @Override
    public void setSourceNode(NodeId nodeId) {
        if (nodeId == null) {
            nodeId = Identifiers.Server;
        }
        super.setSourceNode(nodeId);
    }

    @Override
    public byte[] triggerEvent(DateTime object, DateTime dateTime, byte[] byArray) {
        byte[] byArray2 = super.triggerEvent((DateTime)object, dateTime, byArray);
        object = byArray2;
        return byArray2;
    }
}

