/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.server.NodeManagerUaNode;
import com.prosysopc.ua.types.opcua.SamplingIntervalDiagnosticsType;
import com.prosysopc.ua.types.opcua.server.BaseDataVariableTypeNode;
import org.opcfoundation.ua.builtintypes.LocalizedText;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.QualifiedName;
import org.opcfoundation.ua.builtintypes.UnsignedInteger;

public abstract class SamplingIntervalDiagnosticsTypeNodeBase
extends BaseDataVariableTypeNode
implements SamplingIntervalDiagnosticsType {
    protected SamplingIntervalDiagnosticsTypeNodeBase(NodeManagerUaNode nodeManagerUaNode, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        super(nodeManagerUaNode, nodeId, qualifiedName, localizedText);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
        this.callAfterCreateIfExists(this.getSamplingIntervalNode());
        this.callAfterCreateIfExists(this.getSampledMonitoredItemsCountNode());
        this.callAfterCreateIfExists(this.getMaxSampledMonitoredItemsCountNode());
        this.callAfterCreateIfExists(this.getDisabledMonitoredItemsSamplingCountNode());
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getSamplingIntervalNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "SamplingInterval");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public Double getSamplingInterval() {
        Object object = this.getSamplingIntervalNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (Double)object;
    }

    @Override
    @Mandatory
    public void setSamplingInterval(Double d2) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getSamplingIntervalNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting SamplingInterval failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(d2);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting SamplingInterval failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getSampledMonitoredItemsCountNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "SampledMonitoredItemsCount");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public UnsignedInteger getSampledMonitoredItemsCount() {
        Object object = this.getSampledMonitoredItemsCountNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (UnsignedInteger)object;
    }

    @Override
    @Mandatory
    public void setSampledMonitoredItemsCount(UnsignedInteger unsignedInteger) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getSampledMonitoredItemsCountNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting SampledMonitoredItemsCount failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(unsignedInteger);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting SampledMonitoredItemsCount failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getMaxSampledMonitoredItemsCountNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "MaxSampledMonitoredItemsCount");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public UnsignedInteger getMaxSampledMonitoredItemsCount() {
        Object object = this.getMaxSampledMonitoredItemsCountNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (UnsignedInteger)object;
    }

    @Override
    @Mandatory
    public void setMaxSampledMonitoredItemsCount(UnsignedInteger unsignedInteger) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getMaxSampledMonitoredItemsCountNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting MaxSampledMonitoredItemsCount failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(unsignedInteger);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting MaxSampledMonitoredItemsCount failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getDisabledMonitoredItemsSamplingCountNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "DisabledMonitoredItemsSamplingCount");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public UnsignedInteger getDisabledMonitoredItemsSamplingCount() {
        Object object = this.getDisabledMonitoredItemsSamplingCountNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (UnsignedInteger)object;
    }

    @Override
    @Mandatory
    public void setDisabledMonitoredItemsSamplingCount(UnsignedInteger unsignedInteger) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getDisabledMonitoredItemsSamplingCountNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting DisabledMonitoredItemsSamplingCount failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(unsignedInteger);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting DisabledMonitoredItemsSamplingCount failed unexpectedly", statusException);
        }
    }
}

