/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.server.NodeManagerUaNode;
import com.prosysopc.ua.types.opcua.ProgressEventType;
import com.prosysopc.ua.types.opcua.server.BaseEventTypeNode;
import org.opcfoundation.ua.builtintypes.LocalizedText;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.QualifiedName;
import org.opcfoundation.ua.builtintypes.UnsignedShort;

public abstract class ProgressEventTypeNodeBase
extends BaseEventTypeNode
implements ProgressEventType {
    protected ProgressEventTypeNodeBase(NodeManagerUaNode nodeManagerUaNode, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        super(nodeManagerUaNode, nodeId, qualifiedName, localizedText);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
    }

    @Override
    @Mandatory
    public UaProperty getContextNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Context");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public Object getContext() {
        Object object = this.getContextNode();
        if (object == null) {
            throw new RuntimeException("Mandatory node Context does not exist");
        }
        object = object.getValue().getValue().getValue();
        return object;
    }

    @Override
    @Mandatory
    public void setContext(Object object) {
        UaProperty uaProperty = this.getContextNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting Context failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(object);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting Context failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public UaProperty getProgressNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Progress");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public UnsignedShort getProgress() {
        Object object = this.getProgressNode();
        if (object == null) {
            throw new RuntimeException("Mandatory node Progress does not exist");
        }
        object = object.getValue().getValue().getValue();
        return (UnsignedShort)object;
    }

    @Override
    @Mandatory
    public void setProgress(UnsignedShort unsignedShort) {
        UaProperty uaProperty = this.getProgressNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting Progress failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(unsignedShort);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting Progress failed unexpectedly", statusException);
        }
    }
}

