/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.server.NodeManagerUaNode;
import com.prosysopc.ua.types.opcua.ProgramTransitionAuditEventType;
import com.prosysopc.ua.types.opcua.server.AuditUpdateStateEventTypeNode;
import com.prosysopc.ua.types.opcua.server.FiniteTransitionVariableTypeNode;
import org.opcfoundation.ua.builtintypes.LocalizedText;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.QualifiedName;

public abstract class ProgramTransitionAuditEventTypeNodeBase
extends AuditUpdateStateEventTypeNode
implements ProgramTransitionAuditEventType {
    protected ProgramTransitionAuditEventTypeNodeBase(NodeManagerUaNode nodeManagerUaNode, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        super(nodeManagerUaNode, nodeId, qualifiedName, localizedText);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
        this.callAfterCreateIfExists(this.getTransitionNode());
    }

    @Override
    @Mandatory
    public FiniteTransitionVariableTypeNode getTransitionNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Transition");
        return (FiniteTransitionVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public LocalizedText getTransition() {
        Object object = this.getTransitionNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (LocalizedText)object;
    }

    @Override
    @Mandatory
    public void setTransition(LocalizedText localizedText) {
        FiniteTransitionVariableTypeNode finiteTransitionVariableTypeNode = this.getTransitionNode();
        if (finiteTransitionVariableTypeNode == null) {
            throw new RuntimeException("Setting Transition failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            finiteTransitionVariableTypeNode.setValue(localizedText);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting Transition failed unexpectedly", statusException);
        }
    }
}

