/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.Optional;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.server.NodeManagerUaNode;
import com.prosysopc.ua.server.ServiceContext;
import com.prosysopc.ua.types.opcua.ProgramStateMachineType;
import com.prosysopc.ua.types.opcua.server.BaseObjectTypeNode;
import com.prosysopc.ua.types.opcua.server.FiniteStateMachineTypeNode;
import com.prosysopc.ua.types.opcua.server.FiniteStateVariableTypeNode;
import com.prosysopc.ua.types.opcua.server.FiniteTransitionVariableTypeNode;
import com.prosysopc.ua.types.opcua.server.ProgramDiagnosticTypeNode;
import org.opcfoundation.ua.builtintypes.DiagnosticInfo;
import org.opcfoundation.ua.builtintypes.LocalizedText;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.QualifiedName;
import org.opcfoundation.ua.builtintypes.StatusCode;
import org.opcfoundation.ua.builtintypes.Variant;
import org.opcfoundation.ua.core.ProgramDiagnosticDataType;

public abstract class ProgramStateMachineTypeNodeBase
extends FiniteStateMachineTypeNode
implements ProgramStateMachineType {
    protected ProgramStateMachineTypeNodeBase(NodeManagerUaNode nodeManagerUaNode, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        super(nodeManagerUaNode, nodeId, qualifiedName, localizedText);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
        this.callAfterCreateIfExists(this.getCurrentStateNode());
        this.callAfterCreateIfExists(this.getLastTransitionNode());
        this.callAfterCreateIfExists(this.getProgramDiagnosticsNode());
        this.callAfterCreateIfExists(this.getFinalResultDataNode());
    }

    @Override
    @Mandatory
    public UaProperty getDeletableNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Deletable");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public Boolean isDeletable() {
        Object object = this.getDeletableNode();
        if (object == null) {
            throw new RuntimeException("Mandatory node Deletable does not exist");
        }
        object = object.getValue().getValue().getValue();
        return (Boolean)object;
    }

    @Override
    @Mandatory
    public void setDeletable(Boolean bl) {
        UaProperty uaProperty = this.getDeletableNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting Deletable failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(bl);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting Deletable failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public UaProperty getRecycleCountNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "RecycleCount");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public Integer getRecycleCount() {
        Object object = this.getRecycleCountNode();
        if (object == null) {
            throw new RuntimeException("Mandatory node RecycleCount does not exist");
        }
        object = object.getValue().getValue().getValue();
        return (Integer)object;
    }

    @Override
    @Mandatory
    public void setRecycleCount(Integer n2) {
        UaProperty uaProperty = this.getRecycleCountNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting RecycleCount failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(n2);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting RecycleCount failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public FiniteStateVariableTypeNode getCurrentStateNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "CurrentState");
        return (FiniteStateVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public LocalizedText getCurrentState() {
        Object object = this.getCurrentStateNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (LocalizedText)object;
    }

    @Override
    @Mandatory
    public void setCurrentState(LocalizedText localizedText) {
        FiniteStateVariableTypeNode finiteStateVariableTypeNode = this.getCurrentStateNode();
        if (finiteStateVariableTypeNode == null) {
            throw new RuntimeException("Setting CurrentState failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            finiteStateVariableTypeNode.setValue(localizedText);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting CurrentState failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public FiniteTransitionVariableTypeNode getLastTransitionNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "LastTransition");
        return (FiniteTransitionVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public LocalizedText getLastTransition() {
        Object object = this.getLastTransitionNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (LocalizedText)object;
    }

    @Override
    @Mandatory
    public void setLastTransition(LocalizedText localizedText) {
        FiniteTransitionVariableTypeNode finiteTransitionVariableTypeNode = this.getLastTransitionNode();
        if (finiteTransitionVariableTypeNode == null) {
            throw new RuntimeException("Setting LastTransition failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            finiteTransitionVariableTypeNode.setValue(localizedText);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting LastTransition failed unexpectedly", statusException);
        }
    }

    @Override
    @Optional
    public ProgramDiagnosticTypeNode getProgramDiagnosticsNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ProgramDiagnostics");
        return (ProgramDiagnosticTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Optional
    public ProgramDiagnosticDataType getProgramDiagnostics() {
        Object object = this.getProgramDiagnosticsNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (ProgramDiagnosticDataType)object;
    }

    @Override
    @Optional
    public void setProgramDiagnostics(ProgramDiagnosticDataType programDiagnosticDataType) {
        ProgramDiagnosticTypeNode programDiagnosticTypeNode = this.getProgramDiagnosticsNode();
        if (programDiagnosticTypeNode == null) {
            throw new RuntimeException("Setting ProgramDiagnostics failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            programDiagnosticTypeNode.setValue(programDiagnosticDataType);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting ProgramDiagnostics failed unexpectedly", statusException);
        }
    }

    @Override
    @Optional
    public BaseObjectTypeNode getFinalResultDataNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "FinalResultData");
        return (BaseObjectTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    public Variant[] callMethod(ServiceContext serviceContext, NodeId nodeId, Variant[] variantArray, StatusCode[] statusCodeArray, DiagnosticInfo[] diagnosticInfoArray) throws StatusException {
        Object object = this.getQualifiedName("http://opcfoundation.org/UA/", "Start");
        if ((object = this.getComponent((QualifiedName)object)) != null && object.getNodeId().equals((Object)nodeId)) {
            this.onStart(serviceContext);
            return null;
        }
        object = this.getQualifiedName("http://opcfoundation.org/UA/", "Suspend");
        if ((object = this.getComponent((QualifiedName)object)) != null && object.getNodeId().equals((Object)nodeId)) {
            this.onSuspend(serviceContext);
            return null;
        }
        object = this.getQualifiedName("http://opcfoundation.org/UA/", "Resume");
        if ((object = this.getComponent((QualifiedName)object)) != null && object.getNodeId().equals((Object)nodeId)) {
            this.onResume(serviceContext);
            return null;
        }
        object = this.getQualifiedName("http://opcfoundation.org/UA/", "Halt");
        if ((object = this.getComponent((QualifiedName)object)) != null && object.getNodeId().equals((Object)nodeId)) {
            this.onHalt(serviceContext);
            return null;
        }
        object = this.getQualifiedName("http://opcfoundation.org/UA/", "Reset");
        if ((object = this.getComponent((QualifiedName)object)) != null && object.getNodeId().equals((Object)nodeId)) {
            this.onReset(serviceContext);
            return null;
        }
        return super.callMethod(serviceContext, nodeId, variantArray, statusCodeArray, diagnosticInfoArray);
    }

    @Override
    public void start() throws StatusException {
        this.onStart(ServiceContext.INTERNAL_OPERATION_CONTEXT);
    }

    protected abstract void onStart(ServiceContext var1) throws StatusException;

    @Override
    public void suspend() throws StatusException {
        this.onSuspend(ServiceContext.INTERNAL_OPERATION_CONTEXT);
    }

    protected abstract void onSuspend(ServiceContext var1) throws StatusException;

    @Override
    public void resume() throws StatusException {
        this.onResume(ServiceContext.INTERNAL_OPERATION_CONTEXT);
    }

    protected abstract void onResume(ServiceContext var1) throws StatusException;

    @Override
    public void halt() throws StatusException {
        this.onHalt(ServiceContext.INTERNAL_OPERATION_CONTEXT);
    }

    protected abstract void onHalt(ServiceContext var1) throws StatusException;

    @Override
    public void reset() throws StatusException {
        this.onReset(ServiceContext.INTERNAL_OPERATION_CONTEXT);
    }

    protected abstract void onReset(ServiceContext var1) throws StatusException;
}

