/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.Optional;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.server.NodeManagerUaNode;
import com.prosysopc.ua.types.opcua.OptionSetType;
import com.prosysopc.ua.types.opcua.server.BaseDataVariableTypeNode;
import org.opcfoundation.ua.builtintypes.LocalizedText;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.QualifiedName;

public abstract class OptionSetTypeNodeBase
extends BaseDataVariableTypeNode
implements OptionSetType {
    protected OptionSetTypeNodeBase(NodeManagerUaNode nodeManagerUaNode, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        super(nodeManagerUaNode, nodeId, qualifiedName, localizedText);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
    }

    @Override
    @Mandatory
    public UaProperty getOptionSetValuesNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "OptionSetValues");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public LocalizedText[] getOptionSetValues() {
        Object object = this.getOptionSetValuesNode();
        if (object == null) {
            throw new RuntimeException("Mandatory node OptionSetValues does not exist");
        }
        object = object.getValue().getValue().getValue();
        return (LocalizedText[])object;
    }

    @Override
    @Mandatory
    public void setOptionSetValues(LocalizedText[] localizedTextArray) {
        UaProperty uaProperty = this.getOptionSetValuesNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting OptionSetValues failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(localizedTextArray);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting OptionSetValues failed unexpectedly", statusException);
        }
    }

    @Override
    @Optional
    public UaProperty getBitMaskNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "BitMask");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public Boolean[] getBitMask() {
        Object object = this.getBitMaskNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (Boolean[])object;
    }

    @Override
    @Optional
    public void setBitMask(Boolean[] booleanArray) {
        UaProperty uaProperty = this.getBitMaskNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting BitMask failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(booleanArray);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting BitMask failed unexpectedly", statusException);
        }
    }
}

