/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.server.NodeManagerUaNode;
import com.prosysopc.ua.types.opcua.OffNormalAlarmType;
import com.prosysopc.ua.types.opcua.server.DiscreteAlarmTypeNode;
import org.opcfoundation.ua.builtintypes.LocalizedText;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.QualifiedName;

public abstract class OffNormalAlarmTypeNodeBase
extends DiscreteAlarmTypeNode
implements OffNormalAlarmType {
    protected OffNormalAlarmTypeNodeBase(NodeManagerUaNode nodeManagerUaNode, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        super(nodeManagerUaNode, nodeId, qualifiedName, localizedText);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
    }

    @Override
    @Mandatory
    public UaProperty getNormalStateNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "NormalState");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public NodeId getNormalState() {
        Object object = this.getNormalStateNode();
        if (object == null) {
            throw new RuntimeException("Mandatory node NormalState does not exist");
        }
        object = object.getValue().getValue().getValue();
        return (NodeId)object;
    }

    @Override
    @Mandatory
    public void setNormalState(NodeId nodeId) {
        UaProperty uaProperty = this.getNormalStateNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting NormalState failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(nodeId);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting NormalState failed unexpectedly", statusException);
        }
    }
}

