/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.Optional;
import com.prosysopc.ua.server.NodeManagerUaNode;
import com.prosysopc.ua.types.opcua.NonExclusiveLimitAlarmType;
import com.prosysopc.ua.types.opcua.server.LimitAlarmTypeNode;
import com.prosysopc.ua.types.opcua.server.TwoStateVariableTypeNode;
import org.opcfoundation.ua.builtintypes.LocalizedText;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.QualifiedName;

public abstract class NonExclusiveLimitAlarmTypeNodeBase
extends LimitAlarmTypeNode
implements NonExclusiveLimitAlarmType {
    protected NonExclusiveLimitAlarmTypeNodeBase(NodeManagerUaNode nodeManagerUaNode, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        super(nodeManagerUaNode, nodeId, qualifiedName, localizedText);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
        this.callAfterCreateIfExists(this.getActiveStateNode());
        this.callAfterCreateIfExists(this.getHighHighStateNode());
        this.callAfterCreateIfExists(this.getHighStateNode());
        this.callAfterCreateIfExists(this.getLowStateNode());
        this.callAfterCreateIfExists(this.getLowLowStateNode());
    }

    @Override
    @Mandatory
    public TwoStateVariableTypeNode getActiveStateNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ActiveState");
        return (TwoStateVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public LocalizedText getActiveState() {
        Object object = this.getActiveStateNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (LocalizedText)object;
    }

    @Override
    @Mandatory
    public void setActiveState(LocalizedText localizedText) {
        TwoStateVariableTypeNode twoStateVariableTypeNode = this.getActiveStateNode();
        if (twoStateVariableTypeNode == null) {
            throw new RuntimeException("Setting ActiveState failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            twoStateVariableTypeNode.setValue(localizedText);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting ActiveState failed unexpectedly", statusException);
        }
    }

    @Override
    @Optional
    public TwoStateVariableTypeNode getHighHighStateNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "HighHighState");
        return (TwoStateVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Optional
    public LocalizedText getHighHighState() {
        Object object = this.getHighHighStateNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (LocalizedText)object;
    }

    @Override
    @Optional
    public void setHighHighState(LocalizedText localizedText) {
        TwoStateVariableTypeNode twoStateVariableTypeNode = this.getHighHighStateNode();
        if (twoStateVariableTypeNode == null) {
            throw new RuntimeException("Setting HighHighState failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            twoStateVariableTypeNode.setValue(localizedText);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting HighHighState failed unexpectedly", statusException);
        }
    }

    @Override
    @Optional
    public TwoStateVariableTypeNode getHighStateNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "HighState");
        return (TwoStateVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Optional
    public LocalizedText getHighState() {
        Object object = this.getHighStateNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (LocalizedText)object;
    }

    @Override
    @Optional
    public void setHighState(LocalizedText localizedText) {
        TwoStateVariableTypeNode twoStateVariableTypeNode = this.getHighStateNode();
        if (twoStateVariableTypeNode == null) {
            throw new RuntimeException("Setting HighState failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            twoStateVariableTypeNode.setValue(localizedText);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting HighState failed unexpectedly", statusException);
        }
    }

    @Override
    @Optional
    public TwoStateVariableTypeNode getLowStateNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "LowState");
        return (TwoStateVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Optional
    public LocalizedText getLowState() {
        Object object = this.getLowStateNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (LocalizedText)object;
    }

    @Override
    @Optional
    public void setLowState(LocalizedText localizedText) {
        TwoStateVariableTypeNode twoStateVariableTypeNode = this.getLowStateNode();
        if (twoStateVariableTypeNode == null) {
            throw new RuntimeException("Setting LowState failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            twoStateVariableTypeNode.setValue(localizedText);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting LowState failed unexpectedly", statusException);
        }
    }

    @Override
    @Optional
    public TwoStateVariableTypeNode getLowLowStateNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "LowLowState");
        return (TwoStateVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Optional
    public LocalizedText getLowLowState() {
        Object object = this.getLowLowStateNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (LocalizedText)object;
    }

    @Override
    @Optional
    public void setLowLowState(LocalizedText localizedText) {
        TwoStateVariableTypeNode twoStateVariableTypeNode = this.getLowLowStateNode();
        if (twoStateVariableTypeNode == null) {
            throw new RuntimeException("Setting LowLowState failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            twoStateVariableTypeNode.setValue(localizedText);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting LowLowState failed unexpectedly", statusException);
        }
    }
}

