/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.Optional;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.server.NodeManagerUaNode;
import com.prosysopc.ua.types.opcua.NamespaceMetadataType;
import com.prosysopc.ua.types.opcua.server.AddressSpaceFileTypeNode;
import com.prosysopc.ua.types.opcua.server.BaseObjectTypeNode;
import org.opcfoundation.ua.builtintypes.DateTime;
import org.opcfoundation.ua.builtintypes.LocalizedText;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.QualifiedName;
import org.opcfoundation.ua.core.IdType;

public abstract class NamespaceMetadataTypeNodeBase
extends BaseObjectTypeNode
implements NamespaceMetadataType {
    protected NamespaceMetadataTypeNodeBase(NodeManagerUaNode nodeManagerUaNode, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        super(nodeManagerUaNode, nodeId, qualifiedName, localizedText);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
        this.callAfterCreateIfExists(this.getNamespaceFileNode());
    }

    @Override
    @Mandatory
    public UaProperty getNamespaceUriNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "NamespaceUri");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public String getNamespaceUri() {
        Object object = this.getNamespaceUriNode();
        if (object == null) {
            throw new RuntimeException("Mandatory node NamespaceUri does not exist");
        }
        object = object.getValue().getValue().getValue();
        return (String)object;
    }

    @Override
    @Mandatory
    public void setNamespaceUri(String string) {
        UaProperty uaProperty = this.getNamespaceUriNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting NamespaceUri failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(string);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting NamespaceUri failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public UaProperty getNamespaceVersionNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "NamespaceVersion");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public String getNamespaceVersion() {
        Object object = this.getNamespaceVersionNode();
        if (object == null) {
            throw new RuntimeException("Mandatory node NamespaceVersion does not exist");
        }
        object = object.getValue().getValue().getValue();
        return (String)object;
    }

    @Override
    @Mandatory
    public void setNamespaceVersion(String string) {
        UaProperty uaProperty = this.getNamespaceVersionNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting NamespaceVersion failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(string);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting NamespaceVersion failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public UaProperty getNamespacePublicationDateNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "NamespacePublicationDate");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public DateTime getNamespacePublicationDate() {
        Object object = this.getNamespacePublicationDateNode();
        if (object == null) {
            throw new RuntimeException("Mandatory node NamespacePublicationDate does not exist");
        }
        object = object.getValue().getValue().getValue();
        return (DateTime)object;
    }

    @Override
    @Mandatory
    public void setNamespacePublicationDate(DateTime dateTime) {
        UaProperty uaProperty = this.getNamespacePublicationDateNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting NamespacePublicationDate failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(dateTime);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting NamespacePublicationDate failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public UaProperty getIsNamespaceSubsetNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "IsNamespaceSubset");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public Boolean isIsNamespaceSubset() {
        Object object = this.getIsNamespaceSubsetNode();
        if (object == null) {
            throw new RuntimeException("Mandatory node IsNamespaceSubset does not exist");
        }
        object = object.getValue().getValue().getValue();
        return (Boolean)object;
    }

    @Override
    @Mandatory
    public void setIsNamespaceSubset(Boolean bl) {
        UaProperty uaProperty = this.getIsNamespaceSubsetNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting IsNamespaceSubset failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(bl);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting IsNamespaceSubset failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public UaProperty getStaticNodeIdIdentifierTypesNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "StaticNodeIdIdentifierTypes");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public IdType[] getStaticNodeIdIdentifierTypes() {
        Object object = this.getStaticNodeIdIdentifierTypesNode();
        if (object == null) {
            throw new RuntimeException("Mandatory node StaticNodeIdIdentifierTypes does not exist");
        }
        object = object.getValue().getValue().getValue();
        object = object;
        IdType[] idTypeArray = new IdType[((Integer[])object).length];
        for (int i2 = 0; i2 < ((Integer[])object).length; ++i2) {
            idTypeArray[i2] = IdType.valueOf((Integer)object[i2]);
        }
        return idTypeArray;
    }

    @Override
    @Mandatory
    public void setStaticNodeIdIdentifierTypes(IdType[] idTypeArray) {
        UaProperty uaProperty = this.getStaticNodeIdIdentifierTypesNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting StaticNodeIdIdentifierTypes failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(idTypeArray);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting StaticNodeIdIdentifierTypes failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public UaProperty getStaticNumericNodeIdRangeNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "StaticNumericNodeIdRange");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public String[] getStaticNumericNodeIdRange() {
        Object object = this.getStaticNumericNodeIdRangeNode();
        if (object == null) {
            throw new RuntimeException("Mandatory node StaticNumericNodeIdRange does not exist");
        }
        object = object.getValue().getValue().getValue();
        return (String[])object;
    }

    @Override
    @Mandatory
    public void setStaticNumericNodeIdRange(String[] stringArray) {
        UaProperty uaProperty = this.getStaticNumericNodeIdRangeNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting StaticNumericNodeIdRange failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(stringArray);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting StaticNumericNodeIdRange failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public UaProperty getStaticStringNodeIdPatternNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "StaticStringNodeIdPattern");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public String[] getStaticStringNodeIdPattern() {
        Object object = this.getStaticStringNodeIdPatternNode();
        if (object == null) {
            throw new RuntimeException("Mandatory node StaticStringNodeIdPattern does not exist");
        }
        object = object.getValue().getValue().getValue();
        return (String[])object;
    }

    @Override
    @Mandatory
    public void setStaticStringNodeIdPattern(String[] stringArray) {
        UaProperty uaProperty = this.getStaticStringNodeIdPatternNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting StaticStringNodeIdPattern failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(stringArray);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting StaticStringNodeIdPattern failed unexpectedly", statusException);
        }
    }

    @Override
    @Optional
    public AddressSpaceFileTypeNode getNamespaceFileNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "NamespaceFile");
        return (AddressSpaceFileTypeNode)this.getComponent(qualifiedName);
    }
}

