/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.server.NodeManagerUaNode;
import com.prosysopc.ua.types.opcua.NDimensionArrayItemType;
import com.prosysopc.ua.types.opcua.server.ArrayItemTypeNode;
import org.opcfoundation.ua.builtintypes.LocalizedText;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.QualifiedName;
import org.opcfoundation.ua.core.AxisInformation;

public abstract class NDimensionArrayItemTypeNodeBase
extends ArrayItemTypeNode
implements NDimensionArrayItemType {
    protected NDimensionArrayItemTypeNodeBase(NodeManagerUaNode nodeManagerUaNode, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        super(nodeManagerUaNode, nodeId, qualifiedName, localizedText);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
    }

    @Override
    @Mandatory
    public UaProperty getAxisDefinitionNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "AxisDefinition");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public AxisInformation[] getAxisDefinition() {
        Object object = this.getAxisDefinitionNode();
        if (object == null) {
            throw new RuntimeException("Mandatory node AxisDefinition does not exist");
        }
        object = object.getValue().getValue().getValue();
        return (AxisInformation[])object;
    }

    @Override
    @Mandatory
    public void setAxisDefinition(AxisInformation[] axisInformationArray) {
        UaProperty uaProperty = this.getAxisDefinitionNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting AxisDefinition failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(axisInformationArray);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting AxisDefinition failed unexpectedly", statusException);
        }
    }
}

