/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.server.NodeManagerUaNode;
import com.prosysopc.ua.types.opcua.MultiStateValueDiscreteType;
import com.prosysopc.ua.types.opcua.server.DiscreteItemTypeNode;
import org.opcfoundation.ua.builtintypes.LocalizedText;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.QualifiedName;
import org.opcfoundation.ua.core.EnumValueType;

public abstract class MultiStateValueDiscreteTypeNodeBase
extends DiscreteItemTypeNode
implements MultiStateValueDiscreteType {
    protected MultiStateValueDiscreteTypeNodeBase(NodeManagerUaNode nodeManagerUaNode, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        super(nodeManagerUaNode, nodeId, qualifiedName, localizedText);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
    }

    @Override
    @Mandatory
    public UaProperty getEnumValuesNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "EnumValues");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public EnumValueType[] getEnumValues() {
        Object object = this.getEnumValuesNode();
        if (object == null) {
            throw new RuntimeException("Mandatory node EnumValues does not exist");
        }
        object = object.getValue().getValue().getValue();
        return (EnumValueType[])object;
    }

    @Override
    @Mandatory
    public void setEnumValues(EnumValueType[] enumValueTypeArray) {
        UaProperty uaProperty = this.getEnumValuesNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting EnumValues failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(enumValueTypeArray);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting EnumValues failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public UaProperty getValueAsTextNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ValueAsText");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public LocalizedText getValueAsText() {
        Object object = this.getValueAsTextNode();
        if (object == null) {
            throw new RuntimeException("Mandatory node ValueAsText does not exist");
        }
        object = object.getValue().getValue().getValue();
        return (LocalizedText)object;
    }

    @Override
    @Mandatory
    public void setValueAsText(LocalizedText localizedText) {
        UaProperty uaProperty = this.getValueAsTextNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting ValueAsText failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(localizedText);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting ValueAsText failed unexpectedly", statusException);
        }
    }
}

