/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.nodes.Optional;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.server.NodeManagerUaNode;
import com.prosysopc.ua.types.opcua.LimitAlarmType;
import com.prosysopc.ua.types.opcua.server.AlarmConditionTypeNode;
import org.opcfoundation.ua.builtintypes.LocalizedText;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.QualifiedName;

public abstract class LimitAlarmTypeNodeBase
extends AlarmConditionTypeNode
implements LimitAlarmType {
    protected LimitAlarmTypeNodeBase(NodeManagerUaNode nodeManagerUaNode, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        super(nodeManagerUaNode, nodeId, qualifiedName, localizedText);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
    }

    @Override
    @Optional
    public UaProperty getHighHighLimitNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "HighHighLimit");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public Double getHighHighLimit() {
        Object object = this.getHighHighLimitNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (Double)object;
    }

    @Override
    @Optional
    public void setHighHighLimit(Double d2) {
        UaProperty uaProperty = this.getHighHighLimitNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting HighHighLimit failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(d2);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting HighHighLimit failed unexpectedly", statusException);
        }
    }

    @Override
    @Optional
    public UaProperty getHighLimitNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "HighLimit");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public Double getHighLimit() {
        Object object = this.getHighLimitNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (Double)object;
    }

    @Override
    @Optional
    public void setHighLimit(Double d2) {
        UaProperty uaProperty = this.getHighLimitNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting HighLimit failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(d2);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting HighLimit failed unexpectedly", statusException);
        }
    }

    @Override
    @Optional
    public UaProperty getLowLimitNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "LowLimit");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public Double getLowLimit() {
        Object object = this.getLowLimitNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (Double)object;
    }

    @Override
    @Optional
    public void setLowLimit(Double d2) {
        UaProperty uaProperty = this.getLowLimitNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting LowLimit failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(d2);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting LowLimit failed unexpectedly", statusException);
        }
    }

    @Override
    @Optional
    public UaProperty getLowLowLimitNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "LowLowLimit");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public Double getLowLowLimit() {
        Object object = this.getLowLowLimitNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (Double)object;
    }

    @Override
    @Optional
    public void setLowLowLimit(Double d2) {
        UaProperty uaProperty = this.getLowLowLimitNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting LowLowLimit failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(d2);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting LowLowLimit failed unexpectedly", statusException);
        }
    }
}

