/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.Optional;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.server.NodeManagerUaNode;
import com.prosysopc.ua.types.opcua.HistoricalDataConfigurationType;
import com.prosysopc.ua.types.opcua.server.AggregateConfigurationTypeNode;
import com.prosysopc.ua.types.opcua.server.BaseObjectTypeNode;
import com.prosysopc.ua.types.opcua.server.FolderTypeNode;
import org.opcfoundation.ua.builtintypes.DateTime;
import org.opcfoundation.ua.builtintypes.LocalizedText;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.QualifiedName;
import org.opcfoundation.ua.core.ExceptionDeviationFormat;

public abstract class HistoricalDataConfigurationTypeNodeBase
extends BaseObjectTypeNode
implements HistoricalDataConfigurationType {
    protected HistoricalDataConfigurationTypeNodeBase(NodeManagerUaNode nodeManagerUaNode, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        super(nodeManagerUaNode, nodeId, qualifiedName, localizedText);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
        this.callAfterCreateIfExists(this.getAggregateConfigurationNode());
        this.callAfterCreateIfExists(this.getAggregateFunctionsNode());
    }

    @Override
    @Mandatory
    public UaProperty getSteppedNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Stepped");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public Boolean isStepped() {
        Object object = this.getSteppedNode();
        if (object == null) {
            throw new RuntimeException("Mandatory node Stepped does not exist");
        }
        object = object.getValue().getValue().getValue();
        return (Boolean)object;
    }

    @Override
    @Mandatory
    public void setStepped(Boolean bl) {
        UaProperty uaProperty = this.getSteppedNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting Stepped failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(bl);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting Stepped failed unexpectedly", statusException);
        }
    }

    @Override
    @Optional
    public UaProperty getDefinitionNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Definition");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public String getDefinition() {
        Object object = this.getDefinitionNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (String)object;
    }

    @Override
    @Optional
    public void setDefinition(String string) {
        UaProperty uaProperty = this.getDefinitionNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting Definition failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(string);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting Definition failed unexpectedly", statusException);
        }
    }

    @Override
    @Optional
    public UaProperty getMaxTimeIntervalNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "MaxTimeInterval");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public Double getMaxTimeInterval() {
        Object object = this.getMaxTimeIntervalNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (Double)object;
    }

    @Override
    @Optional
    public void setMaxTimeInterval(Double d2) {
        UaProperty uaProperty = this.getMaxTimeIntervalNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting MaxTimeInterval failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(d2);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting MaxTimeInterval failed unexpectedly", statusException);
        }
    }

    @Override
    @Optional
    public UaProperty getMinTimeIntervalNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "MinTimeInterval");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public Double getMinTimeInterval() {
        Object object = this.getMinTimeIntervalNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (Double)object;
    }

    @Override
    @Optional
    public void setMinTimeInterval(Double d2) {
        UaProperty uaProperty = this.getMinTimeIntervalNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting MinTimeInterval failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(d2);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting MinTimeInterval failed unexpectedly", statusException);
        }
    }

    @Override
    @Optional
    public UaProperty getExceptionDeviationNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ExceptionDeviation");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public Double getExceptionDeviation() {
        Object object = this.getExceptionDeviationNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (Double)object;
    }

    @Override
    @Optional
    public void setExceptionDeviation(Double d2) {
        UaProperty uaProperty = this.getExceptionDeviationNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting ExceptionDeviation failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(d2);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting ExceptionDeviation failed unexpectedly", statusException);
        }
    }

    @Override
    @Optional
    public UaProperty getExceptionDeviationFormatNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ExceptionDeviationFormat");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public ExceptionDeviationFormat getExceptionDeviationFormat() {
        Object object = this.getExceptionDeviationFormatNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return ExceptionDeviationFormat.valueOf((Integer)((Integer)object));
    }

    @Override
    @Optional
    public void setExceptionDeviationFormat(ExceptionDeviationFormat exceptionDeviationFormat) {
        UaProperty uaProperty = this.getExceptionDeviationFormatNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting ExceptionDeviationFormat failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(exceptionDeviationFormat);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting ExceptionDeviationFormat failed unexpectedly", statusException);
        }
    }

    @Override
    @Optional
    public UaProperty getStartOfArchiveNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "StartOfArchive");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public DateTime getStartOfArchive() {
        Object object = this.getStartOfArchiveNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (DateTime)object;
    }

    @Override
    @Optional
    public void setStartOfArchive(DateTime dateTime) {
        UaProperty uaProperty = this.getStartOfArchiveNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting StartOfArchive failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(dateTime);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting StartOfArchive failed unexpectedly", statusException);
        }
    }

    @Override
    @Optional
    public UaProperty getStartOfOnlineArchiveNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "StartOfOnlineArchive");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public DateTime getStartOfOnlineArchive() {
        Object object = this.getStartOfOnlineArchiveNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (DateTime)object;
    }

    @Override
    @Optional
    public void setStartOfOnlineArchive(DateTime dateTime) {
        UaProperty uaProperty = this.getStartOfOnlineArchiveNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting StartOfOnlineArchive failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(dateTime);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting StartOfOnlineArchive failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public AggregateConfigurationTypeNode getAggregateConfigurationNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "AggregateConfiguration");
        return (AggregateConfigurationTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Optional
    public FolderTypeNode getAggregateFunctionsNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "AggregateFunctions");
        return (FolderTypeNode)this.getComponent(qualifiedName);
    }
}

