/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.server.NodeManagerUaNode;
import com.prosysopc.ua.types.opcua.GeneralModelChangeEventType;
import com.prosysopc.ua.types.opcua.server.BaseModelChangeEventTypeNode;
import org.opcfoundation.ua.builtintypes.LocalizedText;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.QualifiedName;
import org.opcfoundation.ua.core.ModelChangeStructureDataType;

public abstract class GeneralModelChangeEventTypeNodeBase
extends BaseModelChangeEventTypeNode
implements GeneralModelChangeEventType {
    protected GeneralModelChangeEventTypeNodeBase(NodeManagerUaNode nodeManagerUaNode, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        super(nodeManagerUaNode, nodeId, qualifiedName, localizedText);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
    }

    @Override
    @Mandatory
    public UaProperty getChangesNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Changes");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public ModelChangeStructureDataType[] getChanges() {
        Object object = this.getChangesNode();
        if (object == null) {
            throw new RuntimeException("Mandatory node Changes does not exist");
        }
        object = object.getValue().getValue().getValue();
        return (ModelChangeStructureDataType[])object;
    }

    @Override
    @Mandatory
    public void setChanges(ModelChangeStructureDataType[] modelChangeStructureDataTypeArray) {
        UaProperty uaProperty = this.getChangesNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting Changes failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(modelChangeStructureDataTypeArray);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting Changes failed unexpectedly", statusException);
        }
    }
}

