/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.UaInstance;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.server.ModelChangeType;
import com.prosysopc.ua.server.NodeManagerUaNode;
import com.prosysopc.ua.server.nodes.BaseNode;
import com.prosysopc.ua.types.opcua.server.GeneralModelChangeEventTypeNodeBase;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.opcfoundation.ua.builtintypes.DateTime;
import org.opcfoundation.ua.builtintypes.LocalizedText;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.QualifiedName;
import org.opcfoundation.ua.builtintypes.UnsignedByte;
import org.opcfoundation.ua.common.ServiceResultException;
import org.opcfoundation.ua.core.ModelChangeStructureDataType;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=2133")
public class GeneralModelChangeEventTypeNode
extends GeneralModelChangeEventTypeNodeBase {
    private final Collection<UaNode> ab = new HashSet<UaNode>();
    private final List<ModelChangeStructureDataType> ac = new ArrayList<ModelChangeStructureDataType>();
    private final Map<NodeId, ModelChangeStructureDataType> ad = new HashMap<NodeId, ModelChangeStructureDataType>();

    protected GeneralModelChangeEventTypeNode(NodeManagerUaNode nodeManagerUaNode, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        super(nodeManagerUaNode, nodeId, qualifiedName, localizedText);
    }

    public synchronized void addChange(NodeId nodeId, NodeId nodeId2, int n2) {
        ModelChangeStructureDataType modelChangeStructureDataType = this.ad.get(nodeId);
        if (modelChangeStructureDataType != null) {
            modelChangeStructureDataType.setVerb(UnsignedByte.valueOf((int)(modelChangeStructureDataType.getVerb().getValue() | n2)));
            return;
        }
        modelChangeStructureDataType = new ModelChangeStructureDataType(nodeId, nodeId2, UnsignedByte.valueOf((int)n2));
        this.ad.put(nodeId, modelChangeStructureDataType);
        this.ac.add(modelChangeStructureDataType);
    }

    public void addChange(NodeId nodeId, NodeId nodeId2, ModelChangeType ... modelChangeTypeArray) {
        int n2 = 0;
        for (ModelChangeType modelChangeType : modelChangeTypeArray) {
            n2 |= modelChangeType.getValue();
        }
        this.addChange(nodeId, nodeId2, n2);
    }

    public synchronized void addChange(NodeId nodeId, NodeId nodeId2, UnsignedByte unsignedByte) {
        this.addChange(nodeId, nodeId2, unsignedByte.getValue());
    }

    public void addChange(UaNode uaNode, ModelChangeType ... modelChangeTypeArray) {
        NodeId nodeId = uaNode.getNodeId();
        NodeId nodeId2 = NodeId.NULL;
        if (uaNode instanceof UaInstance) {
            try {
                nodeId2 = this.getNodeManager().getNamespaceTable().toNodeId(((UaInstance)uaNode).getTypeDefinitionId());
            }
            catch (ServiceResultException serviceResultException) {
                throw new RuntimeException(serviceResultException);
            }
        }
        this.addAffectedNode(uaNode);
        this.addChange(nodeId, nodeId2, modelChangeTypeArray);
    }

    public void addChanges(List<ModelChangeStructureDataType> object) {
        object = object.iterator();
        while (object.hasNext()) {
            ModelChangeStructureDataType modelChangeStructureDataType = (ModelChangeStructureDataType)object.next();
            this.addChange(modelChangeStructureDataType.getAffected(), modelChangeStructureDataType.getAffectedType(), modelChangeStructureDataType.getVerb());
        }
    }

    public void addChanges(ModelChangeStructureDataType[] modelChangeStructureDataTypeArray) {
        if (modelChangeStructureDataTypeArray != null) {
            this.addChanges(Arrays.asList(modelChangeStructureDataTypeArray));
        }
    }

    public synchronized void clearChanges() {
        this.ab.clear();
        this.ad.clear();
        this.ac.clear();
    }

    public synchronized UaNode[] getAffectedNodes() {
        return this.ab.toArray(new UaNode[0]);
    }

    @Override
    public synchronized ModelChangeStructureDataType[] getChanges() {
        return this.ac.toArray(new ModelChangeStructureDataType[this.ac.size()]);
    }

    public synchronized boolean hasChanges() {
        return !this.ac.isEmpty();
    }

    @Override
    public synchronized void setChanges(ModelChangeStructureDataType[] modelChangeStructureDataTypeArray) {
        this.clearChanges();
        this.addChanges(modelChangeStructureDataTypeArray);
    }

    @Override
    public synchronized byte[] triggerEvent(DateTime dateTime, DateTime dateTime2, byte[] byArray) {
        for (UaNode uaNode : this.getAffectedNodes()) {
            if (!(uaNode instanceof BaseNode)) continue;
            uaNode = (BaseNode)uaNode;
            try {
                ((BaseNode)uaNode).incNodeVersion();
            }
            catch (NumberFormatException numberFormatException) {
                ((BaseNode)uaNode).setNodeVersionValue("1");
            }
        }
        byte[] byArray2 = super.triggerEvent(dateTime, dateTime2, byArray);
        this.clearChanges();
        return byArray2;
    }

    protected void addAffectedNode(UaNode uaNode) {
        if (uaNode != null) {
            this.ab.add(uaNode);
        }
    }
}

