/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.server.NodeManagerUaNode;
import com.prosysopc.ua.types.opcua.FiniteTransitionVariableType;
import com.prosysopc.ua.types.opcua.server.TransitionVariableTypeNode;
import org.opcfoundation.ua.builtintypes.LocalizedText;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.QualifiedName;

public abstract class FiniteTransitionVariableTypeNodeBase
extends TransitionVariableTypeNode
implements FiniteTransitionVariableType {
    protected FiniteTransitionVariableTypeNodeBase(NodeManagerUaNode nodeManagerUaNode, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        super(nodeManagerUaNode, nodeId, qualifiedName, localizedText);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
    }

    @Override
    @Mandatory
    public UaProperty getIdNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Id");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public NodeId getId() {
        Object object = this.getIdNode();
        if (object == null) {
            throw new RuntimeException("Mandatory node Id does not exist");
        }
        object = object.getValue().getValue().getValue();
        return (NodeId)object;
    }

    @Override
    @Mandatory
    public void setId(NodeId nodeId) {
        UaProperty uaProperty = this.getIdNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting Id failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(nodeId);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting Id failed unexpectedly", statusException);
        }
    }
}

