/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.Optional;
import com.prosysopc.ua.server.NodeManagerUaNode;
import com.prosysopc.ua.types.opcua.FiniteStateMachineType;
import com.prosysopc.ua.types.opcua.server.FiniteStateVariableTypeNode;
import com.prosysopc.ua.types.opcua.server.FiniteTransitionVariableTypeNode;
import com.prosysopc.ua.types.opcua.server.StateMachineTypeNode;
import org.opcfoundation.ua.builtintypes.LocalizedText;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.QualifiedName;

public abstract class FiniteStateMachineTypeNodeBase
extends StateMachineTypeNode
implements FiniteStateMachineType {
    protected FiniteStateMachineTypeNodeBase(NodeManagerUaNode nodeManagerUaNode, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        super(nodeManagerUaNode, nodeId, qualifiedName, localizedText);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
        this.callAfterCreateIfExists(this.getCurrentStateNode());
        this.callAfterCreateIfExists(this.getLastTransitionNode());
    }

    @Override
    @Mandatory
    public FiniteStateVariableTypeNode getCurrentStateNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "CurrentState");
        return (FiniteStateVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public LocalizedText getCurrentState() {
        Object object = this.getCurrentStateNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (LocalizedText)object;
    }

    @Override
    @Mandatory
    public void setCurrentState(LocalizedText localizedText) {
        FiniteStateVariableTypeNode finiteStateVariableTypeNode = this.getCurrentStateNode();
        if (finiteStateVariableTypeNode == null) {
            throw new RuntimeException("Setting CurrentState failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            finiteStateVariableTypeNode.setValue(localizedText);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting CurrentState failed unexpectedly", statusException);
        }
    }

    @Override
    @Optional
    public FiniteTransitionVariableTypeNode getLastTransitionNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "LastTransition");
        return (FiniteTransitionVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Optional
    public LocalizedText getLastTransition() {
        Object object = this.getLastTransitionNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (LocalizedText)object;
    }

    @Override
    @Optional
    public void setLastTransition(LocalizedText localizedText) {
        FiniteTransitionVariableTypeNode finiteTransitionVariableTypeNode = this.getLastTransitionNode();
        if (finiteTransitionVariableTypeNode == null) {
            throw new RuntimeException("Setting LastTransition failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            finiteTransitionVariableTypeNode.setValue(localizedText);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting LastTransition failed unexpectedly", statusException);
        }
    }
}

