/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.server.NodeManagerUaNode;
import com.prosysopc.ua.server.ServiceContext;
import com.prosysopc.ua.types.opcua.FileType;
import com.prosysopc.ua.types.opcua.server.BaseObjectTypeNode;
import org.opcfoundation.ua.builtintypes.DiagnosticInfo;
import org.opcfoundation.ua.builtintypes.LocalizedText;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.QualifiedName;
import org.opcfoundation.ua.builtintypes.StatusCode;
import org.opcfoundation.ua.builtintypes.UnsignedByte;
import org.opcfoundation.ua.builtintypes.UnsignedInteger;
import org.opcfoundation.ua.builtintypes.UnsignedLong;
import org.opcfoundation.ua.builtintypes.UnsignedShort;
import org.opcfoundation.ua.builtintypes.Variant;

public abstract class FileTypeNodeBase
extends BaseObjectTypeNode
implements FileType {
    protected FileTypeNodeBase(NodeManagerUaNode nodeManagerUaNode, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        super(nodeManagerUaNode, nodeId, qualifiedName, localizedText);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
    }

    @Override
    @Mandatory
    public UaProperty getSizeNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Size");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public UnsignedLong getSize() {
        Object object = this.getSizeNode();
        if (object == null) {
            throw new RuntimeException("Mandatory node Size does not exist");
        }
        object = object.getValue().getValue().getValue();
        return (UnsignedLong)object;
    }

    @Override
    @Mandatory
    public void setSize(UnsignedLong unsignedLong) {
        UaProperty uaProperty = this.getSizeNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting Size failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(unsignedLong);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting Size failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public UaProperty getWritableNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Writable");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public Boolean isWritable() {
        Object object = this.getWritableNode();
        if (object == null) {
            throw new RuntimeException("Mandatory node Writable does not exist");
        }
        object = object.getValue().getValue().getValue();
        return (Boolean)object;
    }

    @Override
    @Mandatory
    public void setWritable(Boolean bl) {
        UaProperty uaProperty = this.getWritableNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting Writable failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(bl);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting Writable failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public UaProperty getUserWritableNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "UserWritable");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public Boolean isUserWritable() {
        Object object = this.getUserWritableNode();
        if (object == null) {
            throw new RuntimeException("Mandatory node UserWritable does not exist");
        }
        object = object.getValue().getValue().getValue();
        return (Boolean)object;
    }

    @Override
    @Mandatory
    public void setUserWritable(Boolean bl) {
        UaProperty uaProperty = this.getUserWritableNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting UserWritable failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(bl);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting UserWritable failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public UaProperty getOpenCountNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "OpenCount");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public UnsignedShort getOpenCount() {
        Object object = this.getOpenCountNode();
        if (object == null) {
            throw new RuntimeException("Mandatory node OpenCount does not exist");
        }
        object = object.getValue().getValue().getValue();
        return (UnsignedShort)object;
    }

    @Override
    @Mandatory
    public void setOpenCount(UnsignedShort unsignedShort) {
        UaProperty uaProperty = this.getOpenCountNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting OpenCount failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(unsignedShort);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting OpenCount failed unexpectedly", statusException);
        }
    }

    @Override
    public Variant[] callMethod(ServiceContext object, NodeId nodeId, Variant[] variantArray, StatusCode[] statusCodeArray, DiagnosticInfo[] diagnosticInfoArray) throws StatusException {
        Object object2 = this.getQualifiedName("http://opcfoundation.org/UA/", "Open");
        if ((object2 = this.getComponent((QualifiedName)object2)) != null && object2.getNodeId().equals((Object)nodeId)) {
            object = this.onOpen((ServiceContext)object, (UnsignedByte)variantArray[0].getValue());
            return new Variant[]{new Variant(object)};
        }
        object2 = this.getQualifiedName("http://opcfoundation.org/UA/", "Close");
        if ((object2 = this.getComponent((QualifiedName)object2)) != null && object2.getNodeId().equals((Object)nodeId)) {
            this.onClose((ServiceContext)object, (UnsignedInteger)variantArray[0].getValue());
            return null;
        }
        object2 = this.getQualifiedName("http://opcfoundation.org/UA/", "Read");
        if ((object2 = this.getComponent((QualifiedName)object2)) != null && object2.getNodeId().equals((Object)nodeId)) {
            object = this.onRead((ServiceContext)object, (UnsignedInteger)variantArray[0].getValue(), (Integer)variantArray[1].getValue());
            return new Variant[]{new Variant(object)};
        }
        object2 = this.getQualifiedName("http://opcfoundation.org/UA/", "Write");
        if ((object2 = this.getComponent((QualifiedName)object2)) != null && object2.getNodeId().equals((Object)nodeId)) {
            this.onWrite((ServiceContext)object, (UnsignedInteger)variantArray[0].getValue(), (byte[])variantArray[1].getValue());
            return null;
        }
        object2 = this.getQualifiedName("http://opcfoundation.org/UA/", "GetPosition");
        if ((object2 = this.getComponent((QualifiedName)object2)) != null && object2.getNodeId().equals((Object)nodeId)) {
            object = this.onGetPosition((ServiceContext)object, (UnsignedInteger)variantArray[0].getValue());
            return new Variant[]{new Variant(object)};
        }
        object2 = this.getQualifiedName("http://opcfoundation.org/UA/", "SetPosition");
        if ((object2 = this.getComponent((QualifiedName)object2)) != null && object2.getNodeId().equals((Object)nodeId)) {
            this.onSetPosition((ServiceContext)object, (UnsignedInteger)variantArray[0].getValue(), (UnsignedLong)variantArray[1].getValue());
            return null;
        }
        return super.callMethod((ServiceContext)object, nodeId, variantArray, statusCodeArray, diagnosticInfoArray);
    }

    @Override
    public UnsignedInteger open(UnsignedByte unsignedByte) throws StatusException {
        return this.onOpen(ServiceContext.INTERNAL_OPERATION_CONTEXT, unsignedByte);
    }

    protected abstract UnsignedInteger onOpen(ServiceContext var1, UnsignedByte var2) throws StatusException;

    @Override
    public void close(UnsignedInteger unsignedInteger) throws StatusException {
        this.onClose(ServiceContext.INTERNAL_OPERATION_CONTEXT, unsignedInteger);
    }

    protected abstract void onClose(ServiceContext var1, UnsignedInteger var2) throws StatusException;

    @Override
    public byte[] read(UnsignedInteger unsignedInteger, Integer n2) throws StatusException {
        return this.onRead(ServiceContext.INTERNAL_OPERATION_CONTEXT, unsignedInteger, n2);
    }

    protected abstract byte[] onRead(ServiceContext var1, UnsignedInteger var2, Integer var3) throws StatusException;

    @Override
    public void write(UnsignedInteger unsignedInteger, byte[] byArray) throws StatusException {
        this.onWrite(ServiceContext.INTERNAL_OPERATION_CONTEXT, unsignedInteger, byArray);
    }

    protected abstract void onWrite(ServiceContext var1, UnsignedInteger var2, byte[] var3) throws StatusException;

    @Override
    public UnsignedLong getPosition(UnsignedInteger unsignedInteger) throws StatusException {
        return this.onGetPosition(ServiceContext.INTERNAL_OPERATION_CONTEXT, unsignedInteger);
    }

    protected abstract UnsignedLong onGetPosition(ServiceContext var1, UnsignedInteger var2) throws StatusException;

    @Override
    public void setPosition(UnsignedInteger unsignedInteger, UnsignedLong unsignedLong) throws StatusException {
        this.onSetPosition(ServiceContext.INTERNAL_OPERATION_CONTEXT, unsignedInteger, unsignedLong);
    }

    protected abstract void onSetPosition(ServiceContext var1, UnsignedInteger var2, UnsignedLong var3) throws StatusException;
}

