/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.FileTypeOpenMode;
import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.server.NodeManagerUaNode;
import com.prosysopc.ua.server.ServiceContext;
import com.prosysopc.ua.server.Session;
import com.prosysopc.ua.types.opcua.server.FileTypeNodeBase;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.opcfoundation.ua.builtintypes.DataValue;
import org.opcfoundation.ua.builtintypes.DateTime;
import org.opcfoundation.ua.builtintypes.DiagnosticInfo;
import org.opcfoundation.ua.builtintypes.LocalizedText;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.QualifiedName;
import org.opcfoundation.ua.builtintypes.StatusCode;
import org.opcfoundation.ua.builtintypes.UnsignedByte;
import org.opcfoundation.ua.builtintypes.UnsignedInteger;
import org.opcfoundation.ua.builtintypes.UnsignedLong;
import org.opcfoundation.ua.builtintypes.UnsignedShort;
import org.opcfoundation.ua.builtintypes.Variant;
import org.opcfoundation.ua.core.StatusCodes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=11575")
public class FileTypeNode
extends FileTypeNodeBase {
    private static long gT = 0L;
    private static Logger logger = LoggerFactory.getLogger(FileTypeNode.class);
    private File file;
    private Map<Session, Map<Long, RandomAccessFile>> gU = null;
    private boolean gV;

    protected FileTypeNode(NodeManagerUaNode nodeManagerUaNode, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        super(nodeManagerUaNode, nodeId, qualifiedName, localizedText);
    }

    @Override
    public void afterCreate() {
        this.initNodeVersion();
        try {
            this.updateOpenCount();
            this.setCurrentWritable(false);
        }
        catch (StatusException statusException) {
            throw new RuntimeException(statusException);
        }
        super.afterCreate();
    }

    public synchronized void close(Session session, Long object) throws StatusException {
        Map<Long, RandomAccessFile> map = this.a(session, false);
        if (map == null) {
            return;
        }
        object = map.remove(object);
        if (map.isEmpty()) {
            this.gU.remove(session);
            if (this.gU.isEmpty()) {
                this.gU = null;
            }
        }
        try {
            ((RandomAccessFile)object).close();
        }
        catch (IOException iOException) {}
        this.gV = false;
        this.updateOpenCount();
        this.updateFileSize();
    }

    public synchronized int getCurrentOpenCount() {
        int n2 = 0;
        if (this.gU != null) {
            for (Map<Long, RandomAccessFile> map : this.gU.values()) {
                n2 += map.size();
            }
        }
        return n2;
    }

    public synchronized long getCurrentPosition(Session object, Long l2) throws StatusException {
        object = this.getRandomAccessFile((Session)object, l2);
        try {
            return ((RandomAccessFile)object).getFilePointer();
        }
        catch (IOException iOException) {
            throw new StatusException(StatusCodes.Bad_UnexpectedError);
        }
    }

    public synchronized long getCurrentSize() throws StatusException {
        this.checkFileExists();
        return this.file.length();
    }

    public synchronized DateTime getCurrentTimestamp() throws StatusException {
        this.checkFileExists();
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(this.file.lastModified());
        return new DateTime(calendar);
    }

    public synchronized File getFile() {
        return this.file;
    }

    public DateTime getTimestamp() throws StatusException {
        return this.getSizeNode().getValue().getSourceTimestamp();
    }

    public synchronized boolean isCurrentWritable() {
        return Boolean.TRUE.equals(this.isWritable());
    }

    public synchronized boolean isWriting() {
        return this.gV;
    }

    public synchronized Long open(Session object, Set<FileTypeOpenMode> object2) throws StatusException {
        Object object3;
        if (logger.isDebugEnabled()) {
            logger.debug("open: mode=" + Arrays.toString(object2.toArray()));
        }
        boolean bl = object2.contains((Object)FileTypeOpenMode.Write);
        if (this.isWriting() || bl && this.getCurrentOpenCount() > 0) {
            throw new StatusException(bl ? StatusCodes.Bad_NotWritable : StatusCodes.Bad_NotReadable, new DiagnosticInfo("File already open.", null, null, null, null, null, null));
        }
        if (bl && !this.isCurrentWritable()) {
            throw new StatusException(StatusCodes.Bad_NotWritable, new DiagnosticInfo("File not Writable", null, null, null, null, null, null));
        }
        if (logger.isDebugEnabled()) {
            logger.debug("open: " + this.file.getPath() + " file.exists=" + this.file.exists());
        }
        Object object4 = object3 = bl ? "rw" : "r";
        if (object2.contains((Object)FileTypeOpenMode.EraseExisting) && this.file.exists()) {
            this.file.delete();
        }
        try {
            if (this.file.exists()) {
                logger.debug("open: file.canWrite=" + this.file.canWrite());
            }
            object3 = new RandomAccessFile(this.file, (String)object3);
            if (object2.contains((Object)FileTypeOpenMode.Append)) {
                try {
                    ((RandomAccessFile)object3).seek(((RandomAccessFile)object3).length());
                }
                catch (IOException iOException) {}
            }
            object = this.a((Session)object, true);
            object2 = this.aU();
            object.put(object2, object3);
            this.gV = bl;
            this.updateOpenCount();
            return object2;
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new StatusException(StatusCodes.Bad_NotFound);
        }
    }

    public synchronized byte[] read(Session object, Long object2, int n2) throws StatusException {
        object = this.getRandomAccessFile((Session)object, (Long)object2);
        try {
            if ((long)n2 > ((RandomAccessFile)object).length() - ((RandomAccessFile)object).getFilePointer()) {
                n2 = (int)(((RandomAccessFile)object).length() - ((RandomAccessFile)object).getFilePointer());
            }
            object2 = new byte[n2];
            ((RandomAccessFile)object).read((byte[])object2);
            return object2;
        }
        catch (IOException iOException) {
            throw new StatusException(StatusCodes.Bad_UnexpectedError);
        }
    }

    public synchronized void setCurrentPosition(Session object, Long l2, long l3) throws StatusException {
        object = this.getRandomAccessFile((Session)object, l2);
        try {
            ((RandomAccessFile)object).seek(Math.min(((RandomAccessFile)object).length(), l3));
            return;
        }
        catch (IOException iOException) {
            throw new StatusException(StatusCodes.Bad_UnexpectedError);
        }
    }

    public synchronized void setCurrentWritable(boolean bl) throws StatusException {
        if (logger.isDebugEnabled()) {
            logger.debug("setWritable: " + bl);
        }
        if (bl && this.file.exists() && !this.file.setWritable(bl)) {
            throw new StatusException("Cannot set the file Writable, file=" + this.file, StatusCodes.Bad_NotWritable);
        }
        this.setWritable(bl);
    }

    public synchronized void setFile(File file) {
        this.file = file;
        this.updateFileSize();
        if (logger.isDebugEnabled()) {
            logger.debug("setFile: " + file.getPath() + " canWrite=" + file.canWrite());
        }
    }

    public void setSize(UnsignedLong unsignedLong, StatusCode statusCode, DateTime dateTime) {
        if (logger.isDebugEnabled()) {
            logger.debug("setSize(" + unsignedLong + ", " + statusCode + ", " + dateTime);
        }
        try {
            this.getSizeNode().setValue(new DataValue(new Variant((Object)unsignedLong), statusCode, dateTime, DateTime.currentTime()));
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException(statusException);
        }
    }

    public void updateFileSize() {
        StatusCode statusCode;
        StatusException statusException;
        if (logger.isDebugEnabled()) {
            logger.debug("updateFileSize");
        }
        UnsignedLong unsignedLong = null;
        try {
            unsignedLong = UnsignedLong.valueOf((long)this.getCurrentSize());
            statusException = this.getCurrentTimestamp();
            statusCode = StatusCode.GOOD;
        }
        catch (StatusException statusException2) {
            statusException = statusException2;
            statusCode = statusException2.getStatusCode();
            statusException = DateTime.MIN_VALUE;
        }
        this.setSize(unsignedLong, statusCode, (DateTime)statusException);
    }

    public synchronized void write(Session object, Long l2, byte[] byArray) throws StatusException {
        object = this.getRandomAccessFile((Session)object, l2);
        try {
            ((RandomAccessFile)object).write(byArray);
            this.updateFileSize();
            return;
        }
        catch (IOException iOException) {
            throw new StatusException(StatusCodes.Bad_NotWritable, (Throwable)iOException);
        }
    }

    private synchronized Map<Long, RandomAccessFile> a(Session session, boolean bl) {
        Map<Long, RandomAccessFile> map;
        if (this.gU == null) {
            if (bl) {
                this.gU = new HashMap<Session, Map<Long, RandomAccessFile>>();
            } else {
                return null;
            }
        }
        if ((map = this.gU.get(session)) == null) {
            map = new HashMap<Long, RandomAccessFile>();
            this.gU.put(session, map);
        }
        return map;
    }

    private synchronized Long aU() {
        return ++gT;
    }

    protected void checkFileExists() throws StatusException {
        if (this.file == null || !this.file.exists()) {
            throw new StatusException(StatusCodes.Bad_NotFound);
        }
    }

    protected RandomAccessFile getRandomAccessFile(Session object, Long l2) throws StatusException {
        if ((object = (object = this.a((Session)object, false)) == null ? null : (RandomAccessFile)object.get(l2)) == null) {
            throw new StatusException(StatusCodes.Bad_InvalidArgument);
        }
        return object;
    }

    @Override
    protected void onClose(ServiceContext serviceContext, UnsignedInteger unsignedInteger) throws StatusException {
        this.close(serviceContext.getSession(), unsignedInteger.longValue());
    }

    @Override
    protected UnsignedLong onGetPosition(ServiceContext serviceContext, UnsignedInteger unsignedInteger) throws StatusException {
        return UnsignedLong.valueOf((long)this.getCurrentPosition(serviceContext.getSession(), unsignedInteger.longValue()));
    }

    @Override
    protected UnsignedInteger onOpen(ServiceContext object, UnsignedByte object2) throws StatusException {
        if (logger.isDebugEnabled()) {
            logger.debug("onOpen: " + this.getFile());
        }
        object = ((ServiceContext)object).getSession();
        object2 = FileTypeOpenMode.getSet(object2);
        object = UnsignedInteger.valueOf((long)this.open((Session)object, (Set<FileTypeOpenMode>)object2));
        if (logger.isDebugEnabled()) {
            logger.debug("onOpen: fileHandle=" + object);
        }
        return object;
    }

    @Override
    protected byte[] onRead(ServiceContext serviceContext, UnsignedInteger unsignedInteger, Integer n2) throws StatusException {
        return this.read(serviceContext.getSession(), unsignedInteger.longValue(), n2);
    }

    @Override
    protected void onSetPosition(ServiceContext serviceContext, UnsignedInteger unsignedInteger, UnsignedLong unsignedLong) throws StatusException {
        this.setCurrentPosition(serviceContext.getSession(), unsignedInteger.longValue(), unsignedLong.longValue());
    }

    @Override
    protected void onWrite(ServiceContext serviceContext, UnsignedInteger unsignedInteger, byte[] byArray) throws StatusException {
        this.write(serviceContext.getSession(), unsignedInteger.longValue(), byArray);
    }

    protected void updateOpenCount() throws StatusException {
        this.setOpenCount(UnsignedShort.valueOf((int)this.getCurrentOpenCount()));
    }
}

