/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.server.NodeManagerUaNode;
import com.prosysopc.ua.types.opcua.ExclusiveLimitAlarmType;
import com.prosysopc.ua.types.opcua.server.ExclusiveLimitStateMachineTypeNode;
import com.prosysopc.ua.types.opcua.server.LimitAlarmTypeNode;
import com.prosysopc.ua.types.opcua.server.TwoStateVariableTypeNode;
import org.opcfoundation.ua.builtintypes.LocalizedText;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.QualifiedName;

public abstract class ExclusiveLimitAlarmTypeNodeBase
extends LimitAlarmTypeNode
implements ExclusiveLimitAlarmType {
    protected ExclusiveLimitAlarmTypeNodeBase(NodeManagerUaNode nodeManagerUaNode, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        super(nodeManagerUaNode, nodeId, qualifiedName, localizedText);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
        this.callAfterCreateIfExists(this.getActiveStateNode());
        this.callAfterCreateIfExists(this.getLimitStateNode());
    }

    @Override
    @Mandatory
    public TwoStateVariableTypeNode getActiveStateNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ActiveState");
        return (TwoStateVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public LocalizedText getActiveState() {
        Object object = this.getActiveStateNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (LocalizedText)object;
    }

    @Override
    @Mandatory
    public void setActiveState(LocalizedText localizedText) {
        TwoStateVariableTypeNode twoStateVariableTypeNode = this.getActiveStateNode();
        if (twoStateVariableTypeNode == null) {
            throw new RuntimeException("Setting ActiveState failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            twoStateVariableTypeNode.setValue(localizedText);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting ActiveState failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public ExclusiveLimitStateMachineTypeNode getLimitStateNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "LimitState");
        return (ExclusiveLimitStateMachineTypeNode)this.getComponent(qualifiedName);
    }
}

