/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.server.NodeManagerUaNode;
import com.prosysopc.ua.types.opcua.ExclusiveDeviationAlarmType;
import com.prosysopc.ua.types.opcua.server.ExclusiveLimitAlarmTypeNode;
import org.opcfoundation.ua.builtintypes.LocalizedText;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.QualifiedName;

public abstract class ExclusiveDeviationAlarmTypeNodeBase
extends ExclusiveLimitAlarmTypeNode
implements ExclusiveDeviationAlarmType {
    protected ExclusiveDeviationAlarmTypeNodeBase(NodeManagerUaNode nodeManagerUaNode, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        super(nodeManagerUaNode, nodeId, qualifiedName, localizedText);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
    }

    @Override
    @Mandatory
    public UaProperty getSetpointNodeNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "SetpointNode");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public NodeId getSetpointNode() {
        Object object = this.getSetpointNodeNode();
        if (object == null) {
            throw new RuntimeException("Mandatory node SetpointNode does not exist");
        }
        object = object.getValue().getValue().getValue();
        return (NodeId)object;
    }

    @Override
    @Mandatory
    public void setSetpointNode(NodeId nodeId) {
        UaProperty uaProperty = this.getSetpointNodeNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting SetpointNode failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(nodeId);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting SetpointNode failed unexpectedly", statusException);
        }
    }
}

