/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.server.NodeManagerUaNode;
import com.prosysopc.ua.server.ServiceContext;
import com.prosysopc.ua.types.opcua.DialogConditionType;
import com.prosysopc.ua.types.opcua.server.ConditionTypeNode;
import com.prosysopc.ua.types.opcua.server.TwoStateVariableTypeNode;
import org.opcfoundation.ua.builtintypes.DiagnosticInfo;
import org.opcfoundation.ua.builtintypes.LocalizedText;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.QualifiedName;
import org.opcfoundation.ua.builtintypes.StatusCode;
import org.opcfoundation.ua.builtintypes.Variant;

public abstract class DialogConditionTypeNodeBase
extends ConditionTypeNode
implements DialogConditionType {
    protected DialogConditionTypeNodeBase(NodeManagerUaNode nodeManagerUaNode, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        super(nodeManagerUaNode, nodeId, qualifiedName, localizedText);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
        this.callAfterCreateIfExists(this.getEnabledStateNode());
        this.callAfterCreateIfExists(this.getDialogStateNode());
    }

    @Override
    @Mandatory
    public UaProperty getPromptNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Prompt");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public LocalizedText getPrompt() {
        Object object = this.getPromptNode();
        if (object == null) {
            throw new RuntimeException("Mandatory node Prompt does not exist");
        }
        object = object.getValue().getValue().getValue();
        return (LocalizedText)object;
    }

    @Override
    @Mandatory
    public void setPrompt(LocalizedText localizedText) {
        UaProperty uaProperty = this.getPromptNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting Prompt failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(localizedText);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting Prompt failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public UaProperty getResponseOptionSetNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ResponseOptionSet");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public LocalizedText[] getResponseOptionSet() {
        Object object = this.getResponseOptionSetNode();
        if (object == null) {
            throw new RuntimeException("Mandatory node ResponseOptionSet does not exist");
        }
        object = object.getValue().getValue().getValue();
        return (LocalizedText[])object;
    }

    @Override
    @Mandatory
    public void setResponseOptionSet(LocalizedText[] localizedTextArray) {
        UaProperty uaProperty = this.getResponseOptionSetNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting ResponseOptionSet failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(localizedTextArray);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting ResponseOptionSet failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public UaProperty getDefaultResponseNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "DefaultResponse");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public Integer getDefaultResponse() {
        Object object = this.getDefaultResponseNode();
        if (object == null) {
            throw new RuntimeException("Mandatory node DefaultResponse does not exist");
        }
        object = object.getValue().getValue().getValue();
        return (Integer)object;
    }

    @Override
    @Mandatory
    public void setDefaultResponse(Integer n2) {
        UaProperty uaProperty = this.getDefaultResponseNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting DefaultResponse failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(n2);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting DefaultResponse failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public UaProperty getOkResponseNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "OkResponse");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public Integer getOkResponse() {
        Object object = this.getOkResponseNode();
        if (object == null) {
            throw new RuntimeException("Mandatory node OkResponse does not exist");
        }
        object = object.getValue().getValue().getValue();
        return (Integer)object;
    }

    @Override
    @Mandatory
    public void setOkResponse(Integer n2) {
        UaProperty uaProperty = this.getOkResponseNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting OkResponse failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(n2);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting OkResponse failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public UaProperty getCancelResponseNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "CancelResponse");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public Integer getCancelResponse() {
        Object object = this.getCancelResponseNode();
        if (object == null) {
            throw new RuntimeException("Mandatory node CancelResponse does not exist");
        }
        object = object.getValue().getValue().getValue();
        return (Integer)object;
    }

    @Override
    @Mandatory
    public void setCancelResponse(Integer n2) {
        UaProperty uaProperty = this.getCancelResponseNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting CancelResponse failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(n2);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting CancelResponse failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public UaProperty getLastResponseNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "LastResponse");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public Integer getLastResponse() {
        Object object = this.getLastResponseNode();
        if (object == null) {
            throw new RuntimeException("Mandatory node LastResponse does not exist");
        }
        object = object.getValue().getValue().getValue();
        return (Integer)object;
    }

    @Override
    @Mandatory
    public void setLastResponse(Integer n2) {
        UaProperty uaProperty = this.getLastResponseNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting LastResponse failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(n2);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting LastResponse failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public TwoStateVariableTypeNode getEnabledStateNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "EnabledState");
        return (TwoStateVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public LocalizedText getEnabledState() {
        Object object = this.getEnabledStateNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (LocalizedText)object;
    }

    @Override
    @Mandatory
    public void setEnabledState(LocalizedText localizedText) {
        TwoStateVariableTypeNode twoStateVariableTypeNode = this.getEnabledStateNode();
        if (twoStateVariableTypeNode == null) {
            throw new RuntimeException("Setting EnabledState failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            twoStateVariableTypeNode.setValue(localizedText);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting EnabledState failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public TwoStateVariableTypeNode getDialogStateNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "DialogState");
        return (TwoStateVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public LocalizedText getDialogState() {
        Object object = this.getDialogStateNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (LocalizedText)object;
    }

    @Override
    @Mandatory
    public void setDialogState(LocalizedText localizedText) {
        TwoStateVariableTypeNode twoStateVariableTypeNode = this.getDialogStateNode();
        if (twoStateVariableTypeNode == null) {
            throw new RuntimeException("Setting DialogState failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            twoStateVariableTypeNode.setValue(localizedText);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting DialogState failed unexpectedly", statusException);
        }
    }

    @Override
    public Variant[] callMethod(ServiceContext serviceContext, NodeId nodeId, Variant[] variantArray, StatusCode[] statusCodeArray, DiagnosticInfo[] diagnosticInfoArray) throws StatusException {
        Object object = this.getQualifiedName("http://opcfoundation.org/UA/", "Respond");
        if ((object = this.getComponent((QualifiedName)object)) != null && object.getNodeId().equals((Object)nodeId)) {
            this.onRespond(serviceContext, (Integer)variantArray[0].getValue());
            return null;
        }
        return super.callMethod(serviceContext, nodeId, variantArray, statusCodeArray, diagnosticInfoArray);
    }

    @Override
    public void respond(Integer n2) throws StatusException {
        this.onRespond(ServiceContext.INTERNAL_OPERATION_CONTEXT, n2);
    }

    protected abstract void onRespond(ServiceContext var1, Integer var2) throws StatusException;
}

