/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.nodes.Optional;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.server.NodeManagerUaNode;
import com.prosysopc.ua.types.opcua.DataTypeDictionaryType;
import com.prosysopc.ua.types.opcua.server.BaseDataVariableTypeNode;
import org.opcfoundation.ua.builtintypes.LocalizedText;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.QualifiedName;

public abstract class DataTypeDictionaryTypeNodeBase
extends BaseDataVariableTypeNode
implements DataTypeDictionaryType {
    protected DataTypeDictionaryTypeNodeBase(NodeManagerUaNode nodeManagerUaNode, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        super(nodeManagerUaNode, nodeId, qualifiedName, localizedText);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
    }

    @Override
    @Optional
    public UaProperty getDataTypeVersionNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "DataTypeVersion");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public String getDataTypeVersion() {
        Object object = this.getDataTypeVersionNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (String)object;
    }

    @Override
    @Optional
    public void setDataTypeVersion(String string) {
        UaProperty uaProperty = this.getDataTypeVersionNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting DataTypeVersion failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(string);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting DataTypeVersion failed unexpectedly", statusException);
        }
    }

    @Override
    @Optional
    public UaProperty getNamespaceUriNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "NamespaceUri");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public String getNamespaceUri() {
        Object object = this.getNamespaceUriNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (String)object;
    }

    @Override
    @Optional
    public void setNamespaceUri(String string) {
        UaProperty uaProperty = this.getNamespaceUriNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting NamespaceUri failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(string);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting NamespaceUri failed unexpectedly", statusException);
        }
    }
}

